/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.mapping.get;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import conductor.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.routing.ShardsIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.IndexService;
import conductor.org.elasticsearch.index.mapper.DocumentFieldMappers;
import conductor.org.elasticsearch.index.mapper.DocumentMapper;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.indices.TypeMissingException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TransportGetFieldMappingsIndexAction
extends TransportSingleShardAction<GetFieldMappingsIndexRequest, GetFieldMappingsResponse> {
    private static final String ACTION_NAME = "indices:admin/mappings/fields/get[index]";
    protected final ClusterService clusterService;
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        @Override
        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }
    };

    @Inject
    public TransportGetFieldMappingsIndexAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetFieldMappingsIndexRequest::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(GetFieldMappingsIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected GetFieldMappingsResponse shardOperation(GetFieldMappingsIndexRequest request, ShardId shardId) {
        Collection typeIntersection;
        assert (shardId != null);
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        Predicate<String> metadataFieldPredicate = this.indicesService::isMetaDataField;
        Predicate<String> fieldPredicate = metadataFieldPredicate.or(this.indicesService.getFieldFilter().apply(shardId.getIndexName()));
        if (request.types().length == 0) {
            typeIntersection = indexService.mapperService().types();
        } else {
            typeIntersection = indexService.mapperService().types().stream().filter(type -> Regex.simpleMatch(request.types(), type)).collect(Collectors.toCollection(ArrayList::new));
            if (typeIntersection.isEmpty()) {
                throw new TypeMissingException(shardId.getIndex(), request.types());
            }
        }
        HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> typeMappings = new HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>();
        for (String type2 : typeIntersection) {
            DocumentMapper documentMapper = indexService.mapperService().documentMapper(type2);
            Map<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMapping = TransportGetFieldMappingsIndexAction.findFieldMappingsByType(fieldPredicate, documentMapper, request);
            if (fieldMapping.isEmpty()) continue;
            typeMappings.put(type2, fieldMapping);
        }
        return new GetFieldMappingsResponse(Collections.singletonMap(shardId.getIndexName(), Collections.unmodifiableMap(typeMappings)));
    }

    @Override
    protected GetFieldMappingsResponse newResponse() {
        return new GetFieldMappingsResponse();
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }

    private static Map<String, GetFieldMappingsResponse.FieldMappingMetaData> findFieldMappingsByType(Predicate<String> fieldPredicate, DocumentMapper documentMapper, GetFieldMappingsIndexRequest request) {
        HashMap<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings = new HashMap<String, GetFieldMappingsResponse.FieldMappingMetaData>();
        DocumentFieldMappers allFieldMappers = documentMapper.mappers();
        for (String field : request.fields()) {
            if (Regex.isMatchAllPattern(field)) {
                for (Mapper fieldMapper : allFieldMappers) {
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern(field)) {
                for (Mapper fieldMapper : allFieldMappers) {
                    if (!Regex.simpleMatch(field, fieldMapper.name())) continue;
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            Mapper fieldMapper = allFieldMappers.getMapper(field);
            if (fieldMapper != null) {
                TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, field, fieldMapper, fieldMappings, request.includeDefaults());
                continue;
            }
            if (!request.probablySingleFieldRequest()) continue;
            fieldMappings.put(field, GetFieldMappingsResponse.FieldMappingMetaData.NULL);
        }
        return Collections.unmodifiableMap(fieldMappings);
    }

    private static void addFieldMapper(Predicate<String> fieldPredicate, String field, Mapper fieldMapper, Map<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        if (fieldPredicate.test(field)) {
            try {
                BytesReference bytes = XContentHelper.toXContent(fieldMapper, XContentType.JSON, includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS, false);
                fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetaData(fieldMapper.name(), bytes));
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize XContent of field [" + field + "]", (Throwable)e, new Object[0]);
            }
        }
    }
}

