/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.open;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import conductor.org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import conductor.org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.DestructiveOperations;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ack.OpenIndexClusterStateUpdateResponse;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportOpenIndexAction
extends TransportMasterNodeAction<OpenIndexRequest, OpenIndexResponse> {
    private final MetaDataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportOpenIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexStateService indexStateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super(settings, "indices:admin/open", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, OpenIndexRequest::new);
        this.indexStateService = indexStateService;
        this.destructiveOperations = destructiveOperations;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected OpenIndexResponse newResponse() {
        return new OpenIndexResponse();
    }

    @Override
    protected void doExecute(Task task, OpenIndexRequest request, ActionListener<OpenIndexResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(OpenIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(OpenIndexRequest request, ClusterState state, final ActionListener<OpenIndexResponse> listener) {
        final Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(new OpenIndexResponse(true, true));
            return;
        }
        OpenIndexClusterStateUpdateRequest updateRequest = ((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).waitForActiveShards(request.waitForActiveShards());
        this.indexStateService.openIndex(updateRequest, new ActionListener<OpenIndexClusterStateUpdateResponse>(){

            @Override
            public void onResponse(OpenIndexClusterStateUpdateResponse response) {
                listener.onResponse(new OpenIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged()));
            }

            @Override
            public void onFailure(Exception t) {
                TransportOpenIndexAction.this.logger.debug(() -> new ParameterizedMessage("failed to open indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }
}

