/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support;

import conductor.org.elasticsearch.action.support.ActiveShardCount;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ClusterStateObserver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.node.NodeClosedException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ActiveShardsObserver
extends AbstractComponent {
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public ActiveShardsObserver(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void waitForActiveShards(final String[] indexNames, ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterState state = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService, null, this.logger, this.threadPool.getThreadContext());
        if (activeShardCount.enoughShardsActive(state, indexNames)) {
            onResult.accept(true);
        } else {
            Predicate<ClusterState> shardsAllocatedPredicate = newState -> activeShardCount.enoughShardsActive((ClusterState)newState, indexNames);
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    ActiveShardsObserver.this.logger.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)Arrays.toString(indexNames));
                    onFailure.accept(new NodeClosedException(ActiveShardsObserver.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }
}

