/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.broadcast.node;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.NoShardAvailableActionException;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.TransportActions;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastRequest;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.node.DiscoveryNodes;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.ShardsIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.NodeShouldNotConnectException;
import conductor.org.elasticsearch.transport.TransportChannel;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestHandler;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportResponseHandler;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;

public abstract class TransportBroadcastByNodeAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardOperationResult extends Streamable>
extends HandledTransportAction<Request, Response> {
    private final ClusterService clusterService;
    private final TransportService transportService;
    final String transportNodeBroadcastAction;

    public TransportBroadcastByNodeAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, String executor) {
        this(settings, actionName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, request, executor, true);
    }

    public TransportBroadcastByNodeAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, String executor, boolean canTripCircuitBreaker) {
        super(settings, actionName, canTripCircuitBreaker, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeBroadcastAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeBroadcastAction, () -> new NodeRequest(), executor, false, canTripCircuitBreaker, new BroadcastByNodeTransportRequestHandler());
    }

    private Response newResponse(Request request, AtomicReferenceArray responses, List<NoShardAvailableActionException> unavailableShardExceptions, Map<String, List<ShardRouting>> nodes, ClusterState clusterState) {
        int totalShards = 0;
        int successfulShards = 0;
        ArrayList broadcastByNodeResponses = new ArrayList();
        ArrayList<DefaultShardOperationFailedException> exceptions = new ArrayList<DefaultShardOperationFailedException>();
        for (int i = 0; i < responses.length(); ++i) {
            if (responses.get(i) instanceof FailedNodeException) {
                FailedNodeException exception = (FailedNodeException)responses.get(i);
                totalShards += nodes.get(exception.nodeId()).size();
                for (ShardRouting shard : nodes.get(exception.nodeId())) {
                    exceptions.add(new DefaultShardOperationFailedException(shard.getIndexName(), shard.getId(), exception));
                }
                continue;
            }
            NodeResponse response = (NodeResponse)responses.get(i);
            broadcastByNodeResponses.addAll(response.results);
            totalShards += response.getTotalShards();
            successfulShards += response.getSuccessfulShards();
            for (BroadcastShardOperationFailedException throwable : response.getExceptions()) {
                if (TransportActions.isShardNotAvailableException(throwable)) continue;
                exceptions.add(new DefaultShardOperationFailedException(throwable.getShardId().getIndexName(), throwable.getShardId().getId(), throwable));
            }
        }
        int failedShards = exceptions.size();
        return this.newResponse(request, totalShards += unavailableShardExceptions.size(), successfulShards, failedShards, broadcastByNodeResponses, exceptions, clusterState);
    }

    protected abstract ShardOperationResult readShardResult(StreamInput var1) throws IOException;

    protected abstract Response newResponse(Request var1, int var2, int var3, int var4, List<ShardOperationResult> var5, List<DefaultShardOperationFailedException> var6, ClusterState var7);

    protected abstract Request readRequestFrom(StreamInput var1) throws IOException;

    protected abstract ShardOperationResult shardOperation(Request var1, ShardRouting var2) throws IOException;

    protected abstract ShardsIterator shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        throw new UnsupportedOperationException("the task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncAction(this, task, request, listener).start();
    }

    public static final class EmptyResult
    implements Streamable {
        public static EmptyResult INSTANCE = new EmptyResult();

        private EmptyResult() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        public static EmptyResult readEmptyResultFrom(StreamInput in) {
            return INSTANCE;
        }
    }

    class NodeResponse
    extends TransportResponse {
        protected String nodeId;
        protected int totalShards;
        protected List<BroadcastShardOperationFailedException> exceptions;
        protected List<ShardOperationResult> results;

        NodeResponse() {
        }

        NodeResponse(String nodeId, int totalShards, List<ShardOperationResult> results, List<BroadcastShardOperationFailedException> exceptions) {
            this.nodeId = nodeId;
            this.totalShards = totalShards;
            this.results = results;
            this.exceptions = exceptions;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public int getTotalShards() {
            return this.totalShards;
        }

        public int getSuccessfulShards() {
            return this.results.size();
        }

        public List<BroadcastShardOperationFailedException> getExceptions() {
            return this.exceptions;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodeId = in.readString();
            this.totalShards = in.readVInt();
            this.results = in.readList(stream -> stream.readBoolean() ? (Streamable)TransportBroadcastByNodeAction.this.readShardResult(stream) : null);
            this.exceptions = in.readBoolean() ? in.readList(BroadcastShardOperationFailedException::new) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            out.writeVInt(this.totalShards);
            out.writeVInt(this.results.size());
            for (Streamable result : this.results) {
                out.writeOptionalStreamable(result);
            }
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                out.writeList(this.exceptions);
            }
        }
    }

    public class NodeRequest
    extends TransportRequest
    implements IndicesRequest {
        private String nodeId;
        private List<ShardRouting> shards;
        protected Request indicesLevelRequest;

        public NodeRequest() {
        }

        public NodeRequest(String nodeId, Request request, List<ShardRouting> shards) {
            this.indicesLevelRequest = request;
            this.shards = shards;
            this.nodeId = nodeId;
        }

        public List<ShardRouting> getShards() {
            return this.shards;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public String[] indices() {
            return ((BroadcastRequest)this.indicesLevelRequest).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((BroadcastRequest)this.indicesLevelRequest).indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.indicesLevelRequest = TransportBroadcastByNodeAction.this.readRequestFrom(in);
            this.shards = in.readList(ShardRouting::new);
            this.nodeId = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ((BroadcastRequest)this.indicesLevelRequest).writeTo(out);
            out.writeList(this.shards);
            out.writeString(this.nodeId);
        }
    }

    class BroadcastByNodeTransportRequestHandler
    implements TransportRequestHandler<NodeRequest> {
        BroadcastByNodeTransportRequestHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            List<ShardRouting> shards = request.getShards();
            int totalShards = shards.size();
            if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                TransportBroadcastByNodeAction.this.logger.trace("[{}] executing operation on [{}] shards", (Object)TransportBroadcastByNodeAction.this.actionName, (Object)totalShards);
            }
            Object[] shardResultOrExceptions = new Object[totalShards];
            int shardIndex = -1;
            for (ShardRouting shardRouting : shards) {
                this.onShardOperation(request, shardResultOrExceptions, ++shardIndex, shardRouting);
            }
            ArrayList<BroadcastShardOperationFailedException> accumulatedExceptions = new ArrayList<BroadcastShardOperationFailedException>();
            ArrayList<Streamable> results = new ArrayList<Streamable>();
            for (int i = 0; i < totalShards; ++i) {
                if (shardResultOrExceptions[i] instanceof BroadcastShardOperationFailedException) {
                    accumulatedExceptions.add((BroadcastShardOperationFailedException)shardResultOrExceptions[i]);
                    continue;
                }
                results.add((Streamable)shardResultOrExceptions[i]);
            }
            channel.sendResponse(new NodeResponse(request.getNodeId(), totalShards, results, accumulatedExceptions));
        }

        private void onShardOperation(NodeRequest request, Object[] shardResults, int shardIndex, ShardRouting shardRouting) {
            block6: {
                try {
                    if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                        TransportBroadcastByNodeAction.this.logger.trace("[{}]  executing operation for shard [{}]", (Object)TransportBroadcastByNodeAction.this.actionName, (Object)shardRouting.shortSummary());
                    }
                    Object result = TransportBroadcastByNodeAction.this.shardOperation(request.indicesLevelRequest, shardRouting);
                    shardResults[shardIndex] = result;
                    if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                        TransportBroadcastByNodeAction.this.logger.trace("[{}]  completed operation for shard [{}]", (Object)TransportBroadcastByNodeAction.this.actionName, (Object)shardRouting.shortSummary());
                    }
                }
                catch (Exception e) {
                    BroadcastShardOperationFailedException failure = new BroadcastShardOperationFailedException(shardRouting.shardId(), "operation " + TransportBroadcastByNodeAction.this.actionName + " failed", e);
                    failure.setShard(shardRouting.shardId());
                    shardResults[shardIndex] = failure;
                    if (TransportActions.isShardNotAvailableException(e)) {
                        if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                            TransportBroadcastByNodeAction.this.logger.trace(new ParameterizedMessage("[{}] failed to execute operation for shard [{}]", (Object)TransportBroadcastByNodeAction.this.actionName, (Object)shardRouting.shortSummary()), (Throwable)e);
                        }
                    }
                    if (!TransportBroadcastByNodeAction.this.logger.isDebugEnabled()) break block6;
                    TransportBroadcastByNodeAction.this.logger.debug(new ParameterizedMessage("[{}] failed to execute operation for shard [{}]", (Object)TransportBroadcastByNodeAction.this.actionName, (Object)shardRouting.shortSummary()), (Throwable)e);
                }
            }
        }
    }

    protected static class AsyncAction {
        private final Task task;
        private final Request request;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final DiscoveryNodes nodes;
        private final Map<String, List<ShardRouting>> nodeIds;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        private List<NoShardAvailableActionException> unavailableShardExceptions = new ArrayList<NoShardAvailableActionException>();
        final /* synthetic */ TransportBroadcastByNodeAction this$0;

        protected AsyncAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.clusterState = ((TransportBroadcastByNodeAction)this$0).clusterService.state();
            this.nodes = this.clusterState.nodes();
            ClusterBlockException globalBlockException = this$0.checkGlobalBlock(this.clusterState, request);
            if (globalBlockException != null) {
                throw globalBlockException;
            }
            String[] concreteIndices = ((TransportBroadcastByNodeAction)this$0).indexNameExpressionResolver.concreteIndexNames(this.clusterState, (IndicesRequest)request);
            ClusterBlockException requestBlockException = this$0.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (requestBlockException != null) {
                throw requestBlockException;
            }
            if (((TransportBroadcastByNodeAction)this$0).logger.isTraceEnabled()) {
                ((TransportBroadcastByNodeAction)this$0).logger.trace("resolving shards for [{}] based on cluster state version [{}]", (Object)((TransportBroadcastByNodeAction)this$0).actionName, (Object)this.clusterState.version());
            }
            ShardsIterator shardIt = this$0.shards(this.clusterState, request, concreteIndices);
            this.nodeIds = new HashMap<String, List<ShardRouting>>();
            for (ShardRouting shard : shardIt) {
                if (shard.assignedToNode() && this.nodes.get(shard.currentNodeId()) != null) {
                    String nodeId = shard.currentNodeId();
                    if (!this.nodeIds.containsKey(nodeId)) {
                        this.nodeIds.put(nodeId, new ArrayList());
                    }
                    this.nodeIds.get(nodeId).add(shard);
                    continue;
                }
                this.unavailableShardExceptions.add(new NoShardAvailableActionException(shard.shardId(), " no shards available for shard " + shard.toString() + " while executing " + ((TransportBroadcastByNodeAction)this$0).actionName));
            }
            this.responses = new AtomicReferenceArray(this.nodeIds.size());
        }

        public void start() {
            if (this.nodeIds.size() == 0) {
                try {
                    this.onCompletion();
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
            } else {
                int nodeIndex = -1;
                for (Map.Entry<String, List<ShardRouting>> entry : this.nodeIds.entrySet()) {
                    DiscoveryNode node = this.nodes.get(entry.getKey());
                    this.sendNodeRequest(node, entry.getValue(), ++nodeIndex);
                }
            }
        }

        private void sendNodeRequest(final DiscoveryNode node, List<ShardRouting> shards, final int nodeIndex) {
            try {
                NodeRequest nodeRequest = new NodeRequest(this.this$0, node.getId(), this.request, shards);
                if (this.task != null) {
                    nodeRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                }
                this.this$0.transportService.sendRequest(node, this.this$0.transportNodeBroadcastAction, nodeRequest, new TransportResponseHandler<NodeResponse>(){

                    @Override
                    public NodeResponse newInstance() {
                        return AsyncAction.this.this$0.new NodeResponse();
                    }

                    @Override
                    public void handleResponse(NodeResponse response) {
                        AsyncAction.this.onNodeResponse(node, nodeIndex, response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncAction.this.onNodeFailure(node, nodeIndex, exp);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }
                });
            }
            catch (Exception e) {
                this.onNodeFailure(node, nodeIndex, e);
            }
        }

        protected void onNodeResponse(DiscoveryNode node, int nodeIndex, NodeResponse response) {
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("received response for [{}] from node [{}]", (Object)this.this$0.actionName, (Object)node.getId());
            }
            if (this.responses.compareAndSet(nodeIndex, null, response) && this.counter.incrementAndGet() == this.responses.length()) {
                this.onCompletion();
            }
        }

        protected void onNodeFailure(DiscoveryNode node, int nodeIndex, Throwable t) {
            String nodeId = node.getId();
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug(new ParameterizedMessage("failed to execute [{}] on node [{}]", (Object)this.this$0.actionName, (Object)nodeId), t);
            }
            if (this.responses.compareAndSet(nodeIndex, null, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t)) && this.counter.incrementAndGet() == this.responses.length()) {
                this.onCompletion();
            }
        }

        protected void onCompletion() {
            BroadcastResponse response = null;
            try {
                response = this.this$0.newResponse(this.request, this.responses, this.unavailableShardExceptions, this.nodeIds, this.clusterState);
            }
            catch (Exception e) {
                this.this$0.logger.debug("failed to combine responses from nodes", (Throwable)e);
                this.listener.onFailure(e);
            }
            if (response != null) {
                try {
                    this.listener.onResponse(response);
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
            }
        }
    }
}

