/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.termvectors;

import conductor.com.carrotsearch.hppc.IntArrayList;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import conductor.org.elasticsearch.action.termvectors.TermVectorsResponse;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiTermVectorsShardResponse
extends ActionResponse {
    IntArrayList locations = new IntArrayList();
    List<TermVectorsResponse> responses = new ArrayList<TermVectorsResponse>();
    List<MultiTermVectorsResponse.Failure> failures = new ArrayList<MultiTermVectorsResponse.Failure>();

    MultiTermVectorsShardResponse() {
    }

    public void add(int location, TermVectorsResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiTermVectorsResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.responses = new ArrayList<TermVectorsResponse>(size);
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                TermVectorsResponse response = new TermVectorsResponse();
                response.readFrom(in);
                this.responses.add(response);
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(MultiTermVectorsResponse.Failure.readFailure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

