/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.entity.ByteArrayEntity;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.RequestConverters;
import conductor.org.elasticsearch.client.ml.CloseJobRequest;
import conductor.org.elasticsearch.client.ml.DeleteCalendarRequest;
import conductor.org.elasticsearch.client.ml.DeleteDatafeedRequest;
import conductor.org.elasticsearch.client.ml.DeleteForecastRequest;
import conductor.org.elasticsearch.client.ml.DeleteJobRequest;
import conductor.org.elasticsearch.client.ml.FlushJobRequest;
import conductor.org.elasticsearch.client.ml.ForecastJobRequest;
import conductor.org.elasticsearch.client.ml.GetBucketsRequest;
import conductor.org.elasticsearch.client.ml.GetCalendarsRequest;
import conductor.org.elasticsearch.client.ml.GetCategoriesRequest;
import conductor.org.elasticsearch.client.ml.GetDatafeedRequest;
import conductor.org.elasticsearch.client.ml.GetDatafeedStatsRequest;
import conductor.org.elasticsearch.client.ml.GetInfluencersRequest;
import conductor.org.elasticsearch.client.ml.GetJobRequest;
import conductor.org.elasticsearch.client.ml.GetJobStatsRequest;
import conductor.org.elasticsearch.client.ml.GetOverallBucketsRequest;
import conductor.org.elasticsearch.client.ml.GetRecordsRequest;
import conductor.org.elasticsearch.client.ml.OpenJobRequest;
import conductor.org.elasticsearch.client.ml.PostDataRequest;
import conductor.org.elasticsearch.client.ml.PreviewDatafeedRequest;
import conductor.org.elasticsearch.client.ml.PutCalendarRequest;
import conductor.org.elasticsearch.client.ml.PutDatafeedRequest;
import conductor.org.elasticsearch.client.ml.PutJobRequest;
import conductor.org.elasticsearch.client.ml.StartDatafeedRequest;
import conductor.org.elasticsearch.client.ml.StopDatafeedRequest;
import conductor.org.elasticsearch.client.ml.UpdateJobRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import java.io.IOException;

final class MLRequestConverters {
    private MLRequestConverters() {
    }

    static Request putJob(PutJobRequest putJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(putJobRequest.getJob().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getJob(GetJobRequest getJobRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(Strings.collectionToCommaDelimitedString(getJobRequest.getJobIds())).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (getJobRequest.getAllowNoJobs() != null) {
            params.putParam("allow_no_jobs", Boolean.toString(getJobRequest.getAllowNoJobs()));
        }
        return request;
    }

    static Request getJobStats(GetJobStatsRequest getJobStatsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(Strings.collectionToCommaDelimitedString(getJobStatsRequest.getJobIds())).addPathPartAsIs("_stats").build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (getJobStatsRequest.getAllowNoJobs() != null) {
            params.putParam("allow_no_jobs", Boolean.toString(getJobStatsRequest.getAllowNoJobs()));
        }
        return request;
    }

    static Request openJob(OpenJobRequest openJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(openJobRequest.getJobId()).addPathPartAsIs("_open").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(openJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request closeJob(CloseJobRequest closeJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(Strings.collectionToCommaDelimitedString(closeJobRequest.getJobIds())).addPathPartAsIs("_close").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(closeJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteJob(DeleteJobRequest deleteJobRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(deleteJobRequest.getJobId()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (deleteJobRequest.getForce() != null) {
            params.putParam("force", Boolean.toString(deleteJobRequest.getForce()));
        }
        if (deleteJobRequest.getWaitForCompletion() != null) {
            params.putParam("wait_for_completion", Boolean.toString(deleteJobRequest.getWaitForCompletion()));
        }
        return request;
    }

    static Request flushJob(FlushJobRequest flushJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(flushJobRequest.getJobId()).addPathPartAsIs("_flush").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(flushJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request forecastJob(ForecastJobRequest forecastJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(forecastJobRequest.getJobId()).addPathPartAsIs("_forecast").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(forecastJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request updateJob(UpdateJobRequest updateJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(updateJobRequest.getJobUpdate().getJobId()).addPathPartAsIs("_update").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(updateJobRequest.getJobUpdate(), RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putDatafeed(PutDatafeedRequest putDatafeedRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(putDatafeedRequest.getDatafeed().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putDatafeedRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getDatafeed(GetDatafeedRequest getDatafeedRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(Strings.collectionToCommaDelimitedString(getDatafeedRequest.getDatafeedIds())).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (getDatafeedRequest.getAllowNoDatafeeds() != null) {
            params.putParam(GetDatafeedRequest.ALLOW_NO_DATAFEEDS.getPreferredName(), Boolean.toString(getDatafeedRequest.getAllowNoDatafeeds()));
        }
        return request;
    }

    static Request deleteDatafeed(DeleteDatafeedRequest deleteDatafeedRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(deleteDatafeedRequest.getDatafeedId()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (deleteDatafeedRequest.getForce() != null) {
            params.putParam("force", Boolean.toString(deleteDatafeedRequest.getForce()));
        }
        return request;
    }

    static Request startDatafeed(StartDatafeedRequest startDatafeedRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(startDatafeedRequest.getDatafeedId()).addPathPartAsIs("_start").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(startDatafeedRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request stopDatafeed(StopDatafeedRequest stopDatafeedRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(Strings.collectionToCommaDelimitedString(stopDatafeedRequest.getDatafeedIds())).addPathPartAsIs("_stop").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(stopDatafeedRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getDatafeedStats(GetDatafeedStatsRequest getDatafeedStatsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(Strings.collectionToCommaDelimitedString(getDatafeedStatsRequest.getDatafeedIds())).addPathPartAsIs("_stats").build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (getDatafeedStatsRequest.getAllowNoDatafeeds() != null) {
            params.putParam("allow_no_datafeeds", Boolean.toString(getDatafeedStatsRequest.getAllowNoDatafeeds()));
        }
        return request;
    }

    static Request previewDatafeed(PreviewDatafeedRequest previewDatafeedRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("datafeeds").addPathPart(previewDatafeedRequest.getDatafeedId()).addPathPartAsIs("_preview").build();
        return new Request("GET", endpoint);
    }

    static Request deleteForecast(DeleteForecastRequest deleteForecastRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(deleteForecastRequest.getJobId()).addPathPartAsIs("_forecast").addPathPart(Strings.collectionToCommaDelimitedString(deleteForecastRequest.getForecastIds())).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (deleteForecastRequest.getAllowNoForecasts() != null) {
            params.putParam("allow_no_forecasts", Boolean.toString(deleteForecastRequest.getAllowNoForecasts()));
        }
        if (deleteForecastRequest.timeout() != null) {
            params.putParam("timeout", deleteForecastRequest.timeout().getStringRep());
        }
        return request;
    }

    static Request getBuckets(GetBucketsRequest getBucketsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(getBucketsRequest.getJobId()).addPathPartAsIs("results").addPathPartAsIs("buckets").build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getBucketsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getCategories(GetCategoriesRequest getCategoriesRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(getCategoriesRequest.getJobId()).addPathPartAsIs("results").addPathPartAsIs("categories").build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getCategoriesRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getOverallBuckets(GetOverallBucketsRequest getOverallBucketsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(Strings.collectionToCommaDelimitedString(getOverallBucketsRequest.getJobIds())).addPathPartAsIs("results").addPathPartAsIs("overall_buckets").build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getOverallBucketsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getRecords(GetRecordsRequest getRecordsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(getRecordsRequest.getJobId()).addPathPartAsIs("results").addPathPartAsIs("records").build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getRecordsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request postData(PostDataRequest postDataRequest) {
        BytesReference content;
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(postDataRequest.getJobId()).addPathPartAsIs("_data").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        if (postDataRequest.getResetStart() != null) {
            params.putParam(PostDataRequest.RESET_START.getPreferredName(), postDataRequest.getResetStart());
        }
        if (postDataRequest.getResetEnd() != null) {
            params.putParam(PostDataRequest.RESET_END.getPreferredName(), postDataRequest.getResetEnd());
        }
        if ((content = postDataRequest.getContent()) != null) {
            BytesRef source = postDataRequest.getContent().toBytesRef();
            ByteArrayEntity byteEntity = new ByteArrayEntity(source.bytes, source.offset, source.length, RequestConverters.createContentType(postDataRequest.getXContentType()));
            request.setEntity(byteEntity);
        }
        return request;
    }

    static Request getInfluencers(GetInfluencersRequest getInfluencersRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("anomaly_detectors").addPathPart(getInfluencersRequest.getJobId()).addPathPartAsIs("results").addPathPartAsIs("influencers").build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getInfluencersRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putCalendar(PutCalendarRequest putCalendarRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("calendars").addPathPart(putCalendarRequest.getCalendar().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putCalendarRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getCalendars(GetCalendarsRequest getCalendarsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("calendars").addPathPart(getCalendarsRequest.getCalendarId()).build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity(getCalendarsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteCalendar(DeleteCalendarRequest deleteCalendarRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("ml").addPathPartAsIs("calendars").addPathPart(deleteCalendarRequest.getCalendarId()).build();
        Request request = new Request("DELETE", endpoint);
        return request;
    }
}

