/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.RollupRequestConverters;
import conductor.org.elasticsearch.client.rollup.GetRollupCapsRequest;
import conductor.org.elasticsearch.client.rollup.GetRollupCapsResponse;
import conductor.org.elasticsearch.client.rollup.GetRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.GetRollupJobResponse;
import conductor.org.elasticsearch.client.rollup.PutRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.PutRollupJobResponse;
import java.io.IOException;
import java.util.Collections;

public class RollupClient {
    private final RestHighLevelClient restHighLevelClient;

    RollupClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutRollupJobResponse putRollupJob(PutRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::putJob, options, PutRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void putRollupJobAsync(PutRollupJobRequest request, RequestOptions options, ActionListener<PutRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::putJob, options, PutRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupJobResponse getRollupJob(GetRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupJobAsync(GetRollupJobRequest request, RequestOptions options, ActionListener<GetRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupCapsResponse getRollupCapabilities(GetRollupCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupCapabilitiesAsync(GetRollupCapsRequest request, RequestOptions options, ActionListener<GetRollupCapsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, listener, Collections.emptySet());
    }
}

