/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.SecurityRequestConverters;
import conductor.org.elasticsearch.client.security.ChangePasswordRequest;
import conductor.org.elasticsearch.client.security.DeleteRoleMappingRequest;
import conductor.org.elasticsearch.client.security.DeleteRoleMappingResponse;
import conductor.org.elasticsearch.client.security.DeleteRoleRequest;
import conductor.org.elasticsearch.client.security.DeleteRoleResponse;
import conductor.org.elasticsearch.client.security.DisableUserRequest;
import conductor.org.elasticsearch.client.security.EmptyResponse;
import conductor.org.elasticsearch.client.security.EnableUserRequest;
import conductor.org.elasticsearch.client.security.GetSslCertificatesRequest;
import conductor.org.elasticsearch.client.security.GetSslCertificatesResponse;
import conductor.org.elasticsearch.client.security.PutRoleMappingRequest;
import conductor.org.elasticsearch.client.security.PutRoleMappingResponse;
import conductor.org.elasticsearch.client.security.PutUserRequest;
import conductor.org.elasticsearch.client.security.PutUserResponse;
import java.io.IOException;
import java.util.Collections;

public final class SecurityClient {
    private final RestHighLevelClient restHighLevelClient;

    SecurityClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutUserResponse putUser(PutUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, Collections.emptySet());
    }

    public void putUserAsync(PutUserRequest request, RequestOptions options, ActionListener<PutUserResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutRoleMappingResponse putRoleMapping(PutRoleMappingRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public void putRoleMappingAsync(PutRoleMappingRequest request, RequestOptions options, ActionListener<PutRoleMappingResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    public EmptyResponse enableUser(EnableUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::enableUser, options, EmptyResponse::fromXContent, Collections.emptySet());
    }

    public void enableUserAsync(EnableUserRequest request, RequestOptions options, ActionListener<EmptyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::enableUser, options, EmptyResponse::fromXContent, listener, Collections.emptySet());
    }

    public EmptyResponse disableUser(DisableUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::disableUser, options, EmptyResponse::fromXContent, Collections.emptySet());
    }

    public void disableUserAsync(DisableUserRequest request, RequestOptions options, ActionListener<EmptyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::disableUser, options, EmptyResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSslCertificatesResponse getSslCertificates(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, Collections.emptySet());
    }

    public void getSslCertificatesAsync(RequestOptions options, ActionListener<GetSslCertificatesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, listener, Collections.emptySet());
    }

    public EmptyResponse changePassword(ChangePasswordRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::changePassword, options, EmptyResponse::fromXContent, Collections.emptySet());
    }

    public void changePasswordAsync(ChangePasswordRequest request, RequestOptions options, ActionListener<EmptyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::changePassword, options, EmptyResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteRoleMappingResponse deleteRoleMapping(DeleteRoleMappingRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public void deleteRoleMappingAsync(DeleteRoleMappingRequest request, RequestOptions options, ActionListener<DeleteRoleMappingResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteRoleResponse deleteRole(DeleteRoleRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, Collections.singleton(404));
    }

    public void deleteRoleAsync(DeleteRoleRequest request, RequestOptions options, ActionListener<DeleteRoleResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, listener, Collections.singleton(404));
    }
}

