/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.client.ml.job.config.Job;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DeleteForecastRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField FORECAST_ID = new ParseField("forecast_id", new String[0]);
    public static final ParseField ALLOW_NO_FORECASTS = new ParseField("allow_no_forecasts", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final String ALL = "_all";
    public static final ConstructingObjectParser<DeleteForecastRequest, Void> PARSER = new ConstructingObjectParser("delete_forecast_request", a -> new DeleteForecastRequest((String)a[0]));
    private final String jobId;
    private List<String> forecastIds = new ArrayList<String>();
    private Boolean allowNoForecasts;
    private TimeValue timeout;

    public static DeleteForecastRequest deleteAllForecasts(String jobId) {
        DeleteForecastRequest request = new DeleteForecastRequest(jobId);
        request.setForecastIds(ALL);
        return request;
    }

    public DeleteForecastRequest(String jobId) {
        this.jobId = Objects.requireNonNull(jobId, Job.ID.getPreferredName());
    }

    public String getJobId() {
        return this.jobId;
    }

    public List<String> getForecastIds() {
        return this.forecastIds;
    }

    public void setForecastIds(String ... forecastIds) {
        this.setForecastIds(Arrays.asList(forecastIds));
    }

    void setForecastIds(List<String> forecastIds) {
        if (forecastIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("forecastIds must not contain null values");
        }
        this.forecastIds = new ArrayList<String>(forecastIds);
    }

    public Boolean getAllowNoForecasts() {
        return this.allowNoForecasts;
    }

    public void setAllowNoForecasts(boolean allowNoForecasts) {
        this.allowNoForecasts = allowNoForecasts;
    }

    public void timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, this.timeout, this.getClass().getSimpleName() + ".timeout");
    }

    public void timeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DeleteForecastRequest that = (DeleteForecastRequest)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.forecastIds, that.forecastIds) && Objects.equals(this.allowNoForecasts, that.allowNoForecasts) && Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.forecastIds, this.allowNoForecasts, this.timeout);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.forecastIds != null) {
            builder.field(FORECAST_ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.forecastIds));
        }
        if (this.allowNoForecasts != null) {
            builder.field(ALLOW_NO_FORECASTS.getPreferredName(), this.allowNoForecasts);
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareStringOrNull((c, p) -> c.setForecastIds(Strings.commaDelimitedListToStringArray(p)), FORECAST_ID);
        PARSER.declareBoolean(DeleteForecastRequest::setAllowNoForecasts, ALLOW_NO_FORECASTS);
        PARSER.declareString(DeleteForecastRequest::timeout, TIMEOUT);
    }
}

