/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.client.Validatable;
import conductor.org.elasticsearch.client.ValidationException;
import conductor.org.elasticsearch.client.security.RefreshPolicy;
import conductor.org.elasticsearch.common.CharArrays;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class PutUserRequest
implements Validatable,
ToXContentObject {
    private final String username;
    private final List<String> roles;
    private final String fullName;
    private final String email;
    private final Map<String, Object> metadata;
    private final char[] password;
    private final boolean enabled;
    private final RefreshPolicy refreshPolicy;

    public PutUserRequest(String username, char[] password, List<String> roles, String fullName, String email, boolean enabled, Map<String, Object> metadata, RefreshPolicy refreshPolicy) {
        this.username = Objects.requireNonNull(username, "username is required");
        this.password = password;
        this.roles = Collections.unmodifiableList(Objects.requireNonNull(roles, "roles must be specified"));
        this.fullName = fullName;
        this.email = email;
        this.enabled = enabled;
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutUserRequest that = (PutUserRequest)o;
        return this.enabled == that.enabled && Objects.equals(this.username, that.username) && Objects.equals(this.roles, that.roles) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.email, that.email) && Objects.equals(this.metadata, that.metadata) && Arrays.equals(this.password, that.password) && this.refreshPolicy == that.refreshPolicy;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.username, this.roles, this.fullName, this.email, this.metadata, this.enabled, this.refreshPolicy});
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.metadata != null && this.metadata.keySet().stream().anyMatch(s -> s.startsWith("_"))) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("metadata keys may not start with [_]");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("username", this.username);
        if (this.password != null) {
            byte[] charBytes = CharArrays.toUtf8Bytes(this.password);
            try {
                builder.field("password").utf8Value(charBytes, 0, charBytes.length);
            }
            finally {
                Arrays.fill(charBytes, (byte)0);
            }
        }
        if (this.roles != null) {
            builder.field("roles", this.roles);
        }
        if (this.fullName != null) {
            builder.field("full_name", this.fullName);
        }
        if (this.email != null) {
            builder.field("email", this.email);
        }
        if (this.metadata != null) {
            builder.field("metadata", this.metadata);
        }
        return builder.endObject();
    }
}

