/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.health;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import java.io.IOException;

public enum ClusterHealthStatus implements Writeable
{
    GREEN(0),
    YELLOW(1),
    RED(2);

    private byte value;

    private ClusterHealthStatus(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public static ClusterHealthStatus readFrom(StreamInput in) throws IOException {
        return ClusterHealthStatus.fromValue(in.readByte());
    }

    public static ClusterHealthStatus fromValue(byte value) throws IOException {
        switch (value) {
            case 0: {
                return GREEN;
            }
            case 1: {
                return YELLOW;
            }
            case 2: {
                return RED;
            }
        }
        throw new IllegalArgumentException("No cluster health status for value [" + value + "]");
    }

    public static ClusterHealthStatus fromString(String status) {
        if (status.equalsIgnoreCase("green")) {
            return GREEN;
        }
        if (status.equalsIgnoreCase("yellow")) {
            return YELLOW;
        }
        if (status.equalsIgnoreCase("red")) {
            return RED;
        }
        throw new IllegalArgumentException("unknown cluster health status [" + status + "]");
    }
}

