/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.geo.parsers;

import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.common.geo.GeoShapeType;
import conductor.org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import conductor.org.elasticsearch.common.geo.builders.EnvelopeBuilder;
import conductor.org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import conductor.org.elasticsearch.common.geo.builders.LineStringBuilder;
import conductor.org.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import conductor.org.elasticsearch.common.geo.builders.MultiPointBuilder;
import conductor.org.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import conductor.org.elasticsearch.common.geo.builders.PointBuilder;
import conductor.org.elasticsearch.common.geo.builders.PolygonBuilder;
import conductor.org.elasticsearch.common.geo.builders.ShapeBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;

public class GeoWKTParser {
    public static final String EMPTY = "EMPTY";
    public static final String SPACE = " ";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String NAN = "NaN";
    private static final String NUMBER = "<NUMBER>";
    private static final String EOF = "END-OF-STREAM";
    private static final String EOL = "END-OF-LINE";

    private GeoWKTParser() {
    }

    public static ShapeBuilder parse(XContentParser parser, GeoShapeFieldMapper shapeMapper) throws IOException, ElasticsearchParseException {
        return GeoWKTParser.parseExpectedType(parser, null, shapeMapper);
    }

    public static ShapeBuilder parseExpectedType(XContentParser parser, GeoShapeType shapeType) throws IOException, ElasticsearchParseException {
        return GeoWKTParser.parseExpectedType(parser, shapeType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShapeBuilder parseExpectedType(XContentParser parser, GeoShapeType shapeType, GeoShapeFieldMapper shapeMapper) throws IOException, ElasticsearchParseException {
        try (StringReader reader = new StringReader(parser.text());){
            boolean ignoreZValue = shapeMapper != null && shapeMapper.ignoreZValue().value() == true;
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.commentChar(35);
            ShapeBuilder builder = GeoWKTParser.parseGeometry(tokenizer, shapeType, ignoreZValue);
            GeoWKTParser.checkEOF(tokenizer);
            ShapeBuilder shapeBuilder = builder;
            return shapeBuilder;
        }
    }

    private static ShapeBuilder parseGeometry(StreamTokenizer stream, GeoShapeType shapeType, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        GeoShapeType type = GeoShapeType.forName(GeoWKTParser.nextWord(stream));
        if (shapeType != null && shapeType != GeoShapeType.GEOMETRYCOLLECTION && !type.wktName().equals(shapeType.wktName())) {
            throw new ElasticsearchParseException("Expected geometry type [{}] but found [{}]", new Object[]{shapeType, type});
        }
        switch (type) {
            case POINT: {
                return GeoWKTParser.parsePoint(stream, ignoreZValue);
            }
            case MULTIPOINT: {
                return GeoWKTParser.parseMultiPoint(stream, ignoreZValue);
            }
            case LINESTRING: {
                return GeoWKTParser.parseLine(stream, ignoreZValue);
            }
            case MULTILINESTRING: {
                return GeoWKTParser.parseMultiLine(stream, ignoreZValue);
            }
            case POLYGON: {
                return GeoWKTParser.parsePolygon(stream, ignoreZValue);
            }
            case MULTIPOLYGON: {
                return GeoWKTParser.parseMultiPolygon(stream, ignoreZValue);
            }
            case ENVELOPE: {
                return GeoWKTParser.parseBBox(stream);
            }
            case GEOMETRYCOLLECTION: {
                return GeoWKTParser.parseGeometryCollection(stream, ignoreZValue);
            }
        }
        throw new IllegalArgumentException("Unknown geometry type: " + (Object)((Object)type));
    }

    private static EnvelopeBuilder parseBBox(StreamTokenizer stream) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        double minLon = GeoWKTParser.nextNumber(stream);
        GeoWKTParser.nextComma(stream);
        double maxLon = GeoWKTParser.nextNumber(stream);
        GeoWKTParser.nextComma(stream);
        double maxLat = GeoWKTParser.nextNumber(stream);
        GeoWKTParser.nextComma(stream);
        double minLat = GeoWKTParser.nextNumber(stream);
        GeoWKTParser.nextCloser(stream);
        return new EnvelopeBuilder(new Coordinate(minLon, maxLat), new Coordinate(maxLon, minLat));
    }

    private static PointBuilder parsePoint(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        PointBuilder pt = new PointBuilder(GeoWKTParser.nextNumber(stream), GeoWKTParser.nextNumber(stream));
        if (GeoWKTParser.isNumberNext(stream)) {
            GeoPoint.assertZValue(ignoreZValue, GeoWKTParser.nextNumber(stream));
        }
        GeoWKTParser.nextCloser(stream);
        return pt;
    }

    private static List<Coordinate> parseCoordinateList(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        CoordinatesBuilder coordinates = new CoordinatesBuilder();
        boolean isOpenParen = false;
        if (GeoWKTParser.isNumberNext(stream) || (isOpenParen = GeoWKTParser.nextWord(stream).equals(LPAREN))) {
            coordinates.coordinate(GeoWKTParser.parseCoordinate(stream, ignoreZValue));
        }
        if (isOpenParen && !GeoWKTParser.nextCloser(stream).equals(RPAREN)) {
            throw new ElasticsearchParseException("expected: [{}]) but found: [{}]" + GeoWKTParser.tokenString(stream), stream.lineno());
        }
        while (GeoWKTParser.nextCloserOrComma(stream).equals(COMMA)) {
            isOpenParen = false;
            if (GeoWKTParser.isNumberNext(stream) || (isOpenParen = GeoWKTParser.nextWord(stream).equals(LPAREN))) {
                coordinates.coordinate(GeoWKTParser.parseCoordinate(stream, ignoreZValue));
            }
            if (!isOpenParen || GeoWKTParser.nextCloser(stream).equals(RPAREN)) continue;
            throw new ElasticsearchParseException("expected: ) but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
        }
        return coordinates.build();
    }

    private static Coordinate parseCoordinate(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        double lon = GeoWKTParser.nextNumber(stream);
        double lat = GeoWKTParser.nextNumber(stream);
        Double z = null;
        if (GeoWKTParser.isNumberNext(stream)) {
            z = GeoPoint.assertZValue(ignoreZValue, GeoWKTParser.nextNumber(stream));
        }
        return z == null ? new Coordinate(lon, lat) : new Coordinate(lon, lat, z.doubleValue());
    }

    private static MultiPointBuilder parseMultiPoint(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        String token = GeoWKTParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        return new MultiPointBuilder(GeoWKTParser.parseCoordinateList(stream, ignoreZValue));
    }

    private static LineStringBuilder parseLine(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        String token = GeoWKTParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        return new LineStringBuilder(GeoWKTParser.parseCoordinateList(stream, ignoreZValue));
    }

    private static MultiLineStringBuilder parseMultiLine(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        String token = GeoWKTParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        MultiLineStringBuilder builder = new MultiLineStringBuilder();
        builder.linestring(GeoWKTParser.parseLine(stream, ignoreZValue));
        while (GeoWKTParser.nextCloserOrComma(stream).equals(COMMA)) {
            builder.linestring(GeoWKTParser.parseLine(stream, ignoreZValue));
        }
        return builder;
    }

    private static PolygonBuilder parsePolygon(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        PolygonBuilder builder = new PolygonBuilder(GeoWKTParser.parseLine(stream, ignoreZValue), ShapeBuilder.Orientation.RIGHT);
        while (GeoWKTParser.nextCloserOrComma(stream).equals(COMMA)) {
            builder.hole(GeoWKTParser.parseLine(stream, ignoreZValue));
        }
        return builder;
    }

    private static MultiPolygonBuilder parseMultiPolygon(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        MultiPolygonBuilder builder = new MultiPolygonBuilder().polygon(GeoWKTParser.parsePolygon(stream, ignoreZValue));
        while (GeoWKTParser.nextCloserOrComma(stream).equals(COMMA)) {
            builder.polygon(GeoWKTParser.parsePolygon(stream, ignoreZValue));
        }
        return builder;
    }

    private static GeometryCollectionBuilder parseGeometryCollection(StreamTokenizer stream, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        GeometryCollectionBuilder builder = new GeometryCollectionBuilder().shape(GeoWKTParser.parseGeometry(stream, GeoShapeType.GEOMETRYCOLLECTION, ignoreZValue));
        while (GeoWKTParser.nextCloserOrComma(stream).equals(COMMA)) {
            builder.shape(GeoWKTParser.parseGeometry(stream, null, ignoreZValue));
        }
        return builder;
    }

    private static String nextWord(StreamTokenizer stream) throws ElasticsearchParseException, IOException {
        switch (stream.nextToken()) {
            case -3: {
                String word = stream.sval;
                return word.equalsIgnoreCase(EMPTY) ? EMPTY : word;
            }
            case 40: {
                return LPAREN;
            }
            case 41: {
                return RPAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        throw new ElasticsearchParseException("expected word but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
    }

    private static double nextNumber(StreamTokenizer stream) throws IOException, ElasticsearchParseException {
        if (stream.nextToken() == -3) {
            if (stream.sval.equalsIgnoreCase(NAN)) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(stream.sval);
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("invalid number found: " + stream.sval, stream.lineno());
            }
        }
        throw new ElasticsearchParseException("expected number but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
    }

    private static String tokenString(StreamTokenizer stream) {
        switch (stream.ttype) {
            case -3: {
                return stream.sval;
            }
            case -1: {
                return EOF;
            }
            case 10: {
                return EOL;
            }
            case -2: {
                return NUMBER;
            }
        }
        return "'" + (char)stream.ttype + "'";
    }

    private static boolean isNumberNext(StreamTokenizer stream) throws IOException {
        int type = stream.nextToken();
        stream.pushBack();
        return type == -3;
    }

    private static String nextEmptyOrOpen(StreamTokenizer stream) throws IOException, ElasticsearchParseException {
        String next = GeoWKTParser.nextWord(stream);
        if (next.equals(EMPTY) || next.equals(LPAREN)) {
            return next;
        }
        throw new ElasticsearchParseException("expected EMPTY or ( but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
    }

    private static String nextCloser(StreamTokenizer stream) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextWord(stream).equals(RPAREN)) {
            return RPAREN;
        }
        throw new ElasticsearchParseException("expected ) but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
    }

    private static String nextComma(StreamTokenizer stream) throws IOException, ElasticsearchParseException {
        if (GeoWKTParser.nextWord(stream).equals(COMMA)) {
            return COMMA;
        }
        throw new ElasticsearchParseException("expected , but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
    }

    private static String nextCloserOrComma(StreamTokenizer stream) throws IOException, ElasticsearchParseException {
        String token = GeoWKTParser.nextWord(stream);
        if (token.equals(COMMA) || token.equals(RPAREN)) {
            return token;
        }
        throw new ElasticsearchParseException("expected , or ) but found: " + GeoWKTParser.tokenString(stream), stream.lineno());
    }

    private static void checkEOF(StreamTokenizer stream) throws ElasticsearchParseException, IOException {
        if (stream.nextToken() != -1) {
            throw new ElasticsearchParseException("expected end of WKT string but found additional text: " + GeoWKTParser.tokenString(stream), stream.lineno());
        }
    }
}

