/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject;

import conductor.org.elasticsearch.common.inject.AbstractProcessor;
import conductor.org.elasticsearch.common.inject.Scope;
import conductor.org.elasticsearch.common.inject.internal.Annotations;
import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.spi.ScopeBinding;
import java.lang.annotation.Annotation;
import java.util.Objects;

class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command) {
        Scope existing;
        Scope scope = command.getScope();
        Class<? extends Annotation> annotationType = command.getAnnotationType();
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.withSource(annotationType).missingScopeAnnotation();
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.withSource(annotationType).missingRuntimeRetention(command.getSource());
        }
        if ((existing = this.injector.state.getScope(Objects.requireNonNull(annotationType, "annotation type"))) != null) {
            this.errors.duplicateScopes(existing, annotationType, scope);
        } else {
            this.injector.state.putAnnotation(annotationType, Objects.requireNonNull(scope, "scope"));
        }
        return true;
    }
}

