/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public interface DateFormatter {
    public TemporalAccessor parse(String var1);

    public DateFormatter withZone(ZoneId var1);

    public DateFormatter withLocale(Locale var1);

    public String format(TemporalAccessor var1);

    public String pattern();

    public Locale getLocale();

    public ZoneId getZone();

    public DateFormatter parseDefaulting(Map<TemporalField, Long> var1);

    public static DateFormatter merge(DateFormatter ... formatters) {
        return new MergedDateFormatter(formatters);
    }

    public static class MergedDateFormatter
    implements DateFormatter {
        private final String format;
        private final DateFormatter[] formatters;

        MergedDateFormatter(DateFormatter ... formatters) {
            this.formatters = formatters;
            this.format = Arrays.stream(formatters).map(DateFormatter::pattern).collect(Collectors.joining("||"));
        }

        @Override
        public TemporalAccessor parse(String input) {
            DateTimeParseException failure = null;
            for (DateFormatter formatter : this.formatters) {
                try {
                    return formatter.parse(input);
                }
                catch (DateTimeParseException e) {
                    if (failure == null) {
                        failure = e;
                        continue;
                    }
                    failure.addSuppressed(e);
                }
            }
            throw failure;
        }

        @Override
        public DateFormatter withZone(ZoneId zoneId) {
            return new MergedDateFormatter((DateFormatter[])Arrays.stream(this.formatters).map(f -> f.withZone(zoneId)).toArray(DateFormatter[]::new));
        }

        @Override
        public DateFormatter withLocale(Locale locale) {
            return new MergedDateFormatter((DateFormatter[])Arrays.stream(this.formatters).map(f -> f.withLocale(locale)).toArray(DateFormatter[]::new));
        }

        @Override
        public String format(TemporalAccessor accessor) {
            return this.formatters[0].format(accessor);
        }

        @Override
        public String pattern() {
            return this.format;
        }

        @Override
        public Locale getLocale() {
            return this.formatters[0].getLocale();
        }

        @Override
        public ZoneId getZone() {
            return this.formatters[0].getZone();
        }

        @Override
        public DateFormatter parseDefaulting(Map<TemporalField, Long> fields) {
            return new MergedDateFormatter((DateFormatter[])Arrays.stream(this.formatters).map(f -> f.parseDefaulting(fields)).toArray(DateFormatter[]::new));
        }
    }
}

