/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.cache.request;

import conductor.org.apache.lucene.util.Accountable;
import conductor.org.elasticsearch.common.metrics.CounterMetric;
import conductor.org.elasticsearch.index.cache.request.RequestCacheStats;

public final class ShardRequestCache {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final CounterMetric hitCount = new CounterMetric();
    final CounterMetric missCount = new CounterMetric();

    public RequestCacheStats stats() {
        return new RequestCacheStats(this.totalMetric.count(), this.evictionsMetric.count(), this.hitCount.count(), this.missCount.count());
    }

    public void onHit() {
        this.hitCount.inc();
    }

    public void onMiss() {
        this.missCount.inc();
    }

    public void onCached(Accountable key, Accountable value) {
        this.totalMetric.inc(key.ramBytesUsed() + value.ramBytesUsed());
    }

    public void onRemoval(Accountable key, Accountable value, boolean evicted) {
        if (evicted) {
            this.evictionsMetric.inc();
        }
        long dec = 0L;
        if (key != null) {
            dec += key.ramBytesUsed();
        }
        if (value != null) {
            dec += value.ramBytesUsed();
        }
        this.totalMetric.dec(dec);
    }
}

