/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fieldvisitor;

import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.StoredFieldVisitor;
import conductor.org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.mapper.Uid;
import java.io.IOException;

public class SingleFieldsVisitor
extends FieldsVisitor {
    private String field;

    public SingleFieldsVisitor(String field) {
        super(false);
        this.field = field;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (fieldInfo.name.equals(this.field)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (fieldInfo.name.equals("_uid") && ("_type".equals(this.field) || "_id".equals(this.field))) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    public void reset(String field) {
        this.field = field;
        super.reset();
    }

    @Override
    public void postProcess(MapperService mapperService) {
        super.postProcess(mapperService);
        if (this.id != null) {
            this.addValue("_id", this.id);
        }
        if (this.type != null) {
            this.addValue("_type", this.type);
        }
        if (this.type != null && this.id != null) {
            this.addValue("_uid", Uid.createUid(this.type, this.id));
        }
    }
}

