/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.rankeval;

import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.rankeval.RankEvalAction;
import conductor.org.elasticsearch.index.rankeval.RankEvalRequest;
import conductor.org.elasticsearch.index.rankeval.RankEvalSpec;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestRankEvalAction
extends BaseRestHandler {
    public static String ENDPOINT = "_rank_eval";

    public RestRankEvalAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/" + ENDPOINT, this);
        controller.registerHandler(RestRequest.Method.POST, "/" + ENDPOINT, this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/" + ENDPOINT, this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/" + ENDPOINT, this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RankEvalRequest rankEvalRequest = new RankEvalRequest();
        try (XContentParser parser = request.contentOrSourceParamParser();){
            RestRankEvalAction.parseRankEvalRequest(rankEvalRequest, request, parser);
        }
        return channel -> client.executeLocally(RankEvalAction.INSTANCE, rankEvalRequest, new RestToXContentListener((RestChannel)channel));
    }

    private static void parseRankEvalRequest(RankEvalRequest rankEvalRequest, RestRequest request, XContentParser parser) {
        rankEvalRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        rankEvalRequest.indicesOptions(IndicesOptions.fromRequest(request, rankEvalRequest.indicesOptions()));
        RankEvalSpec spec = RankEvalSpec.parse(parser);
        rankEvalRequest.setRankEvalSpec(spec);
    }

    @Override
    public String getName() {
        return "rank_eval_action";
    }
}

