/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.os;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.util.Constants;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.common.io.PathUtils;
import conductor.org.elasticsearch.monitor.Probes;
import conductor.org.elasticsearch.monitor.os.OsInfo;
import conductor.org.elasticsearch.monitor.os.OsStats;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OsProbe {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getFreePhysicalMemorySize = OsProbe.getMethod("getFreePhysicalMemorySize");
    private static final Method getTotalPhysicalMemorySize = OsProbe.getMethod("getTotalPhysicalMemorySize");
    private static final Method getFreeSwapSpaceSize = OsProbe.getMethod("getFreeSwapSpaceSize");
    private static final Method getTotalSwapSpaceSize = OsProbe.getMethod("getTotalSwapSpaceSize");
    private static final Method getSystemLoadAverage = OsProbe.getMethod("getSystemLoadAverage");
    private static final Method getSystemCpuLoad = OsProbe.getMethod("getSystemCpuLoad");
    private static final String CONTROL_GROUPS_HIERARCHY_OVERRIDE = System.getProperty("es.cgroups.hierarchy.override");
    private final Logger logger = LogManager.getLogger(this.getClass());

    public long getFreePhysicalMemorySize() {
        if (getFreePhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getFreePhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getTotalPhysicalMemorySize() {
        if (getTotalPhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalPhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getFreeSwapSpaceSize() {
        if (getFreeSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getFreeSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getTotalSwapSpaceSize() {
        if (getTotalSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    final double[] getSystemLoadAverage() {
        if (Constants.WINDOWS) {
            return null;
        }
        if (Constants.LINUX) {
            try {
                String procLoadAvg = this.readProcLoadavg();
                assert (procLoadAvg.matches("(\\d+\\.\\d+\\s+){3}\\d+/\\d+\\s+\\d+"));
                String[] fields = procLoadAvg.split("\\s+");
                return new double[]{Double.parseDouble(fields[0]), Double.parseDouble(fields[1]), Double.parseDouble(fields[2])};
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("error reading /proc/loadavg", (Throwable)e);
                }
                return null;
            }
        }
        assert (Constants.MAC_OS_X);
        if (getSystemLoadAverage == null) {
            return null;
        }
        try {
            double oneMinuteLoadAverage = (Double)getSystemLoadAverage.invoke((Object)osMxBean, new Object[0]);
            return new double[]{oneMinuteLoadAverage >= 0.0 ? oneMinuteLoadAverage : -1.0, -1.0, -1.0};
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("error reading one minute load average from operating system", (Throwable)e);
            }
            return null;
        }
    }

    @SuppressForbidden(reason="access /proc/loadavg")
    String readProcLoadavg() throws IOException {
        return this.readSingleLine(PathUtils.get("/proc/loadavg", new String[0]));
    }

    public short getSystemCpuPercent() {
        return Probes.getLoadAndScaleToPercent(getSystemCpuLoad, osMxBean);
    }

    private String readSingleLine(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        assert (lines != null && lines.size() == 1);
        return lines.get(0);
    }

    private Map<String, String> getControlGroups() throws IOException {
        List<String> lines = this.readProcSelfCgroup();
        HashMap<String, String> controllerMap = new HashMap<String, String>();
        for (String line : lines) {
            String[] controllers;
            String[] fields = line.split(":");
            assert (fields.length == 3);
            for (String controller : controllers = fields[1].split(",")) {
                String controlGroupPath = CONTROL_GROUPS_HIERARCHY_OVERRIDE != null ? CONTROL_GROUPS_HIERARCHY_OVERRIDE : fields[2];
                String previous = controllerMap.put(controller, controlGroupPath);
                assert (previous == null);
            }
        }
        return controllerMap;
    }

    @SuppressForbidden(reason="access /proc/self/cgroup")
    List<String> readProcSelfCgroup() throws IOException {
        List<String> lines = Files.readAllLines(PathUtils.get("/proc/self/cgroup", new String[0]));
        assert (lines != null && !lines.isEmpty());
        return lines;
    }

    private long getCgroupCpuAcctUsageNanos(String controlGroup) throws IOException {
        return Long.parseLong(this.readSysFsCgroupCpuAcctCpuAcctUsage(controlGroup));
    }

    @SuppressForbidden(reason="access /sys/fs/cgroup/cpuacct")
    String readSysFsCgroupCpuAcctCpuAcctUsage(String controlGroup) throws IOException {
        return this.readSingleLine(PathUtils.get("/sys/fs/cgroup/cpuacct", controlGroup, "cpuacct.usage"));
    }

    private long getCgroupCpuAcctCpuCfsPeriodMicros(String controlGroup) throws IOException {
        return Long.parseLong(this.readSysFsCgroupCpuAcctCpuCfsPeriod(controlGroup));
    }

    @SuppressForbidden(reason="access /sys/fs/cgroup/cpu")
    String readSysFsCgroupCpuAcctCpuCfsPeriod(String controlGroup) throws IOException {
        return this.readSingleLine(PathUtils.get("/sys/fs/cgroup/cpu", controlGroup, "cpu.cfs_period_us"));
    }

    private long getCgroupCpuAcctCpuCfsQuotaMicros(String controlGroup) throws IOException {
        return Long.parseLong(this.readSysFsCgroupCpuAcctCpuAcctCfsQuota(controlGroup));
    }

    @SuppressForbidden(reason="access /sys/fs/cgroup/cpu")
    String readSysFsCgroupCpuAcctCpuAcctCfsQuota(String controlGroup) throws IOException {
        return this.readSingleLine(PathUtils.get("/sys/fs/cgroup/cpu", controlGroup, "cpu.cfs_quota_us"));
    }

    private OsStats.Cgroup.CpuStat getCgroupCpuAcctCpuStat(String controlGroup) throws IOException {
        List<String> lines = this.readSysFsCgroupCpuAcctCpuStat(controlGroup);
        long numberOfPeriods = -1L;
        long numberOfTimesThrottled = -1L;
        long timeThrottledNanos = -1L;
        for (String line : lines) {
            String[] fields = line.split("\\s+");
            switch (fields[0]) {
                case "nr_periods": {
                    numberOfPeriods = Long.parseLong(fields[1]);
                    break;
                }
                case "nr_throttled": {
                    numberOfTimesThrottled = Long.parseLong(fields[1]);
                    break;
                }
                case "throttled_time": {
                    timeThrottledNanos = Long.parseLong(fields[1]);
                }
            }
        }
        assert (numberOfPeriods != -1L);
        assert (numberOfTimesThrottled != -1L);
        assert (timeThrottledNanos != -1L);
        return new OsStats.Cgroup.CpuStat(numberOfPeriods, numberOfTimesThrottled, timeThrottledNanos);
    }

    @SuppressForbidden(reason="access /sys/fs/cgroup/cpu")
    List<String> readSysFsCgroupCpuAcctCpuStat(String controlGroup) throws IOException {
        List<String> lines = Files.readAllLines(PathUtils.get("/sys/fs/cgroup/cpu", controlGroup, "cpu.stat"));
        assert (lines != null && lines.size() == 3);
        return lines;
    }

    private String getCgroupMemoryLimitInBytes(String controlGroup) throws IOException {
        return this.readSysFsCgroupMemoryLimitInBytes(controlGroup);
    }

    @SuppressForbidden(reason="access /sys/fs/cgroup/memory")
    String readSysFsCgroupMemoryLimitInBytes(String controlGroup) throws IOException {
        return this.readSingleLine(PathUtils.get("/sys/fs/cgroup/memory", controlGroup, "memory.limit_in_bytes"));
    }

    private String getCgroupMemoryUsageInBytes(String controlGroup) throws IOException {
        return this.readSysFsCgroupMemoryUsageInBytes(controlGroup);
    }

    @SuppressForbidden(reason="access /sys/fs/cgroup/memory")
    String readSysFsCgroupMemoryUsageInBytes(String controlGroup) throws IOException {
        return this.readSingleLine(PathUtils.get("/sys/fs/cgroup/memory", controlGroup, "memory.usage_in_bytes"));
    }

    @SuppressForbidden(reason="access /proc/self/cgroup, /sys/fs/cgroup/cpu, /sys/fs/cgroup/cpuacct and /sys/fs/cgroup/memory")
    boolean areCgroupStatsAvailable() {
        if (!Files.exists(PathUtils.get("/proc/self/cgroup", new String[0]), new LinkOption[0])) {
            return false;
        }
        if (!Files.exists(PathUtils.get("/sys/fs/cgroup/cpu", new String[0]), new LinkOption[0])) {
            return false;
        }
        if (!Files.exists(PathUtils.get("/sys/fs/cgroup/cpuacct", new String[0]), new LinkOption[0])) {
            return false;
        }
        return Files.exists(PathUtils.get("/sys/fs/cgroup/memory", new String[0]), new LinkOption[0]);
    }

    private OsStats.Cgroup getCgroup() {
        try {
            if (!this.areCgroupStatsAvailable()) {
                return null;
            }
            Map<String, String> controllerMap = this.getControlGroups();
            assert (!controllerMap.isEmpty());
            String cpuAcctControlGroup = controllerMap.get("cpuacct");
            assert (cpuAcctControlGroup != null);
            long cgroupCpuAcctUsageNanos = this.getCgroupCpuAcctUsageNanos(cpuAcctControlGroup);
            String cpuControlGroup = controllerMap.get("cpu");
            assert (cpuControlGroup != null);
            long cgroupCpuAcctCpuCfsPeriodMicros = this.getCgroupCpuAcctCpuCfsPeriodMicros(cpuControlGroup);
            long cgroupCpuAcctCpuCfsQuotaMicros = this.getCgroupCpuAcctCpuCfsQuotaMicros(cpuControlGroup);
            OsStats.Cgroup.CpuStat cpuStat = this.getCgroupCpuAcctCpuStat(cpuControlGroup);
            String memoryControlGroup = controllerMap.get("memory");
            assert (memoryControlGroup != null);
            String cgroupMemoryLimitInBytes = this.getCgroupMemoryLimitInBytes(memoryControlGroup);
            String cgroupMemoryUsageInBytes = this.getCgroupMemoryUsageInBytes(memoryControlGroup);
            return new OsStats.Cgroup(cpuAcctControlGroup, cgroupCpuAcctUsageNanos, cpuControlGroup, cgroupCpuAcctCpuCfsPeriodMicros, cgroupCpuAcctCpuCfsQuotaMicros, cpuStat, memoryControlGroup, cgroupMemoryLimitInBytes, cgroupMemoryUsageInBytes);
        }
        catch (IOException e) {
            this.logger.debug("error reading control group stats", (Throwable)e);
            return null;
        }
    }

    public static OsProbe getInstance() {
        return OsProbeHolder.INSTANCE;
    }

    OsProbe() {
    }

    public OsInfo osInfo(long refreshInterval, int allocatedProcessors) {
        return new OsInfo(refreshInterval, Runtime.getRuntime().availableProcessors(), allocatedProcessors, Constants.OS_NAME, Constants.OS_ARCH, Constants.OS_VERSION);
    }

    public OsStats osStats() {
        OsStats.Cpu cpu = new OsStats.Cpu(this.getSystemCpuPercent(), this.getSystemLoadAverage());
        OsStats.Mem mem = new OsStats.Mem(this.getTotalPhysicalMemorySize(), this.getFreePhysicalMemorySize());
        OsStats.Swap swap = new OsStats.Swap(this.getTotalSwapSpaceSize(), this.getFreeSwapSpaceSize());
        OsStats.Cgroup cgroup = Constants.LINUX ? this.getCgroup() : null;
        return new OsStats(System.currentTimeMillis(), cpu, mem, swap, cgroup);
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class OsProbeHolder {
        private static final OsProbe INSTANCE = new OsProbe();

        private OsProbeHolder() {
        }
    }
}

