/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.protocol.xpack.watcher;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class PutWatchResponse
extends ActionResponse
implements ToXContentObject {
    private static final ObjectParser<PutWatchResponse, Void> PARSER = new ObjectParser("x_pack_put_watch_response", PutWatchResponse::new);
    private String id;
    private long version;
    private boolean created;

    public PutWatchResponse() {
    }

    public PutWatchResponse(String id, long version, boolean created) {
        this.id = id;
        this.version = version;
        this.created = created;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setVersion(long version) {
        this.version = version;
    }

    private void setCreated(boolean created) {
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutWatchResponse that = (PutWatchResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.created, that.created);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.created);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeVLong(this.version);
        out.writeBoolean(this.created);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.version = in.readVLong();
        this.created = in.readBoolean();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("_id", this.id).field("_version", this.version).field("created", this.created).endObject();
    }

    public static PutWatchResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(PutWatchResponse::setId, new ParseField("_id", new String[0]));
        PARSER.declareLong(PutWatchResponse::setVersion, new ParseField("_version", new String[0]));
        PARSER.declareBoolean(PutWatchResponse::setCreated, new ParseField("created", new String[0]));
    }
}

