/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.repositories;

import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import conductor.org.elasticsearch.common.inject.AbstractModule;
import conductor.org.elasticsearch.common.inject.multibindings.MapBinder;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.plugins.RepositoryPlugin;
import conductor.org.elasticsearch.repositories.RepositoriesService;
import conductor.org.elasticsearch.repositories.Repository;
import conductor.org.elasticsearch.repositories.fs.FsRepository;
import conductor.org.elasticsearch.snapshots.RestoreService;
import conductor.org.elasticsearch.snapshots.SnapshotShardsService;
import conductor.org.elasticsearch.snapshots.SnapshotsService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoriesModule
extends AbstractModule {
    private final Map<String, Repository.Factory> repositoryTypes;

    public RepositoriesModule(Environment env, List<RepositoryPlugin> repoPlugins, NamedXContentRegistry namedXContentRegistry) {
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", metadata -> new FsRepository(metadata, env, namedXContentRegistry));
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repoPlugin.getRepositories(env, namedXContentRegistry);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + entry.getKey() + "] is already registered");
            }
        }
        this.repositoryTypes = Collections.unmodifiableMap(factories);
    }

    @Override
    protected void configure() {
        this.bind(RepositoriesService.class).asEagerSingleton();
        this.bind(SnapshotsService.class).asEagerSingleton();
        this.bind(SnapshotShardsService.class).asEagerSingleton();
        this.bind(TransportNodesSnapshotsStatus.class).asEagerSingleton();
        this.bind(RestoreService.class).asEagerSingleton();
        MapBinder<String, Repository.Factory> typesBinder = MapBinder.newMapBinder(this.binder(), String.class, Repository.Factory.class);
        this.repositoryTypes.forEach((k, v) -> typesBinder.addBinding((String)k).toInstance(v));
    }
}

