/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import conductor.org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.cluster.metadata.AliasMetaData;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.stream.Collectors;

public class RestGetAliasesAction
extends BaseRestHandler {
    public RestGetAliasesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias/{name}", this);
    }

    @Override
    public String getName() {
        return "get_aliases_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final boolean namesProvided = request.hasParam("name");
        final String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestBuilderListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response, XContentBuilder builder) throws Exception {
                RestStatus status;
                ImmutableOpenMap<String, List<AliasMetaData>> aliasMap = response.getAliases();
                HashSet<String> aliasNames = new HashSet<String>();
                HashSet<String> indicesToDisplay = new HashSet<String>();
                for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : aliasMap) {
                    for (AliasMetaData aliasMetaData : (List)objectObjectCursor.value) {
                        aliasNames.add(aliasMetaData.alias());
                        if (!namesProvided) continue;
                        indicesToDisplay.add((String)objectObjectCursor.key);
                    }
                }
                SortedSet<String> difference = Sets.sortedDifference(Arrays.stream(aliases).collect(Collectors.toSet()), aliasNames);
                ArrayList<String> arrayList = new ArrayList<String>();
                block2: for (String pattern : difference) {
                    if (!pattern.contains("*")) continue;
                    for (String aliasName : aliasNames) {
                        if (!Regex.simpleMatch(pattern, aliasName)) continue;
                        arrayList.add(pattern);
                        continue block2;
                    }
                }
                difference.removeAll(arrayList);
                builder.startObject();
                if (difference.isEmpty()) {
                    status = RestStatus.OK;
                } else {
                    status = RestStatus.NOT_FOUND;
                    String message = difference.size() == 1 ? String.format(Locale.ROOT, "alias [%s] missing", Strings.collectionToCommaDelimitedString(difference)) : String.format(Locale.ROOT, "aliases [%s] missing", Strings.collectionToCommaDelimitedString(difference));
                    builder.field("error", message);
                    builder.field("status", status.getStatus());
                }
                for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : response.getAliases()) {
                    if (namesProvided && (!namesProvided || !indicesToDisplay.contains(objectObjectCursor.key))) continue;
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("aliases");
                    for (AliasMetaData alias : (List)objectObjectCursor.value) {
                        AliasMetaData.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

