/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.search.SearchHit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public final class SearchHits
implements Streamable,
ToXContentFragment,
Iterable<SearchHit> {
    public static final SearchHit[] EMPTY = new SearchHit[0];
    private SearchHit[] hits;
    public long totalHits;
    private float maxScore;

    public static SearchHits empty() {
        return new SearchHits(EMPTY, 0L, 0.0f);
    }

    SearchHits() {
    }

    public SearchHits(SearchHit[] hits, long totalHits, float maxScore) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public SearchHit[] getHits() {
        return this.hits;
    }

    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    @Override
    public Iterator<SearchHit> iterator() {
        return Arrays.stream(this.getHits()).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("hits");
        builder.field("total", this.totalHits);
        if (Float.isNaN(this.maxScore)) {
            builder.nullField("max_score");
        } else {
            builder.field("max_score", this.maxScore);
        }
        builder.field("hits");
        builder.startArray();
        for (SearchHit hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SearchHits fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        }
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        long totalHits = 0L;
        float maxScore = 0.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("total".equals(currentFieldName)) {
                    totalHits = parser.longValue();
                    continue;
                }
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = parser.floatValue();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = Float.NaN;
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("hits".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        hits.add(SearchHit.fromXContent(parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        SearchHits searchHits = new SearchHits(hits.toArray(new SearchHit[hits.size()]), totalHits, maxScore);
        return searchHits;
    }

    public static SearchHits readSearchHits(StreamInput in) throws IOException {
        SearchHits hits = new SearchHits();
        hits.readFrom(in);
        return hits;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        boolean hasTotalHits = in.getVersion().onOrAfter(Version.V_6_0_0_beta1) ? in.readBoolean() : true;
        this.totalHits = hasTotalHits ? in.readVLong() : -1L;
        this.maxScore = in.readFloat();
        int size = in.readVInt();
        if (size == 0) {
            this.hits = EMPTY;
        } else {
            this.hits = new SearchHit[size];
            for (int i = 0; i < this.hits.length; ++i) {
                this.hits[i] = SearchHit.readSearchHit(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean hasTotalHits;
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            hasTotalHits = this.totalHits >= 0L;
            out.writeBoolean(hasTotalHits);
        } else {
            assert (this.totalHits >= 0L);
            hasTotalHits = true;
        }
        if (hasTotalHits) {
            out.writeVLong(this.totalHits);
        }
        out.writeFloat(this.maxScore);
        out.writeVInt(this.hits.length);
        if (this.hits.length > 0) {
            for (SearchHit hit : this.hits) {
                hit.writeTo(out);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHits other = (SearchHits)obj;
        return Objects.equals(this.totalHits, other.totalHits) && Objects.equals(Float.valueOf(this.maxScore), Float.valueOf(other.maxScore)) && Arrays.equals(this.hits, other.hits);
    }

    public int hashCode() {
        return Objects.hash(this.totalHits, Float.valueOf(this.maxScore), Arrays.hashCode(this.hits));
    }

    public static final class Fields {
        public static final String HITS = "hits";
        public static final String TOTAL = "total";
        public static final String MAX_SCORE = "max_score";
    }
}

