/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations;

import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalOrder;
import conductor.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class BucketOrder
implements ToXContentObject,
Writeable {
    public static BucketOrder count(boolean asc) {
        return asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC;
    }

    public static BucketOrder key(boolean asc) {
        return asc ? InternalOrder.KEY_ASC : InternalOrder.KEY_DESC;
    }

    public static BucketOrder aggregation(String path, boolean asc) {
        return new InternalOrder.Aggregation(path, asc);
    }

    public static BucketOrder aggregation(String path, String metricName, boolean asc) {
        return new InternalOrder.Aggregation(path + "." + metricName, asc);
    }

    public static BucketOrder compound(List<BucketOrder> orders) {
        return new InternalOrder.CompoundOrder(orders);
    }

    public static BucketOrder compound(BucketOrder ... orders) {
        return BucketOrder.compound(Arrays.asList(orders));
    }

    public abstract Comparator<MultiBucketsAggregation.Bucket> comparator(Aggregator var1);

    abstract byte id();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeOrder(this, out);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

