/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket;

import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.Aggregations;
import conductor.org.elasticsearch.search.aggregations.ParsedAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public abstract class ParsedSingleBucketAggregation
extends ParsedAggregation
implements SingleBucketAggregation {
    private long docCount;
    protected Aggregations aggregations = new Aggregations(Collections.emptyList());

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    protected void setDocCount(long docCount) {
        this.docCount = docCount;
    }

    @Override
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        return builder;
    }

    protected static <T extends ParsedSingleBucketAggregation> T parseXContent(XContentParser parser, T aggregation, String name) throws IOException {
        aggregation.setName(name);
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = parser.currentName();
        if (token == XContentParser.Token.FIELD_NAME) {
            token = parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        ArrayList aggregations = new ArrayList();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                aggregation.setDocCount(parser.longValue());
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (Aggregation.CommonFields.META.getPreferredName().equals(currentFieldName)) {
                aggregation.metadata = parser.map();
                continue;
            }
            XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
        }
        aggregation.aggregations = new Aggregations(aggregations);
        return aggregation;
    }
}

