/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.matrix.stats;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.ObjectArray;
import conductor.org.elasticsearch.index.fielddata.NumericDoubleValues;
import conductor.org.elasticsearch.search.MultiValueMode;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.matrix.stats.InternalMatrixStats;
import conductor.org.elasticsearch.search.aggregations.matrix.stats.RunningStats;
import conductor.org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ArrayValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class MatrixStatsAggregator
extends MetricsAggregator {
    private final ArrayValuesSource.NumericArrayValuesSource valuesSources;
    ObjectArray<RunningStats> stats;

    MatrixStatsAggregator(String name, Map<String, ValuesSource.Numeric> valuesSources, SearchContext context, Aggregator parent, MultiValueMode multiValueMode, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        if (valuesSources != null && !valuesSources.isEmpty()) {
            this.valuesSources = new ArrayValuesSource.NumericArrayValuesSource(valuesSources, multiValueMode);
            this.stats = context.bigArrays().newObjectArray(1L);
        } else {
            this.valuesSources = null;
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSources == null ? false : this.valuesSources.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final NumericDoubleValues[] values = new NumericDoubleValues[this.valuesSources.fieldNames().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valuesSources.getField(i, ctx);
        }
        return new LeafBucketCollectorBase(sub, values){
            final String[] fieldNames;
            final double[] fieldVals;
            {
                super(arg0, arg1);
                this.fieldNames = MatrixStatsAggregator.this.valuesSources.fieldNames();
                this.fieldVals = new double[this.fieldNames.length];
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (this.includeDocument(doc)) {
                    MatrixStatsAggregator.this.stats = bigArrays.grow(MatrixStatsAggregator.this.stats, bucket + 1L);
                    RunningStats stat = MatrixStatsAggregator.this.stats.get(bucket);
                    if (stat == null) {
                        stat = new RunningStats(this.fieldNames, this.fieldVals);
                        MatrixStatsAggregator.this.stats.set(bucket, stat);
                    } else {
                        stat.add(this.fieldNames, this.fieldVals);
                    }
                }
            }

            private boolean includeDocument(int doc) throws IOException {
                for (int i = 0; i < this.fieldVals.length; ++i) {
                    double value;
                    NumericDoubleValues doubleValues = values[i];
                    if (doubleValues.advanceExact(doc)) {
                        value = doubleValues.doubleValue();
                        if (value == Double.NEGATIVE_INFINITY) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    this.fieldVals[i] = value;
                }
                return true;
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null || bucket >= this.stats.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMatrixStats(this.name, this.stats.size(), this.stats.get(bucket), null, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMatrixStats(this.name, 0L, null, null, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.stats);
    }
}

