/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricValue;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.InternalBucketMetricValue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ParsedBucketMetricValue
extends ParsedSingleValueNumericMetricsAggregation
implements BucketMetricValue {
    private List<String> keys = Collections.emptyList();
    private static final ObjectParser<ParsedBucketMetricValue, Void> PARSER = new ObjectParser(ParsedBucketMetricValue.class.getSimpleName(), true, ParsedBucketMetricValue::new);

    @Override
    public String[] keys() {
        return this.keys.toArray(new String[this.keys.size()]);
    }

    @Override
    public String getType() {
        return "bucket_metric_value";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        builder.startArray(InternalBucketMetricValue.KEYS_FIELD.getPreferredName());
        for (String key : this.keys) {
            builder.value(key);
        }
        builder.endArray();
        return builder;
    }

    public static ParsedBucketMetricValue fromXContent(XContentParser parser, String name) {
        ParsedBucketMetricValue bucketMetricValue = PARSER.apply(parser, null);
        bucketMetricValue.setName(name);
        return bucketMetricValue;
    }

    static {
        ParsedBucketMetricValue.declareSingleValueFields(PARSER, Double.NEGATIVE_INFINITY);
        PARSER.declareStringArray((agg, value) -> {
            agg.keys = value;
        }, InternalBucketMetricValue.KEYS_FIELD);
    }
}

