/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.apache.lucene.search.Explanation;
import conductor.org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.rescore.RescoreContext;
import java.io.IOException;

public final class ExplainFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.explain()) {
            return;
        }
        try {
            int topLevelDocId = hitContext.hit().docId();
            Explanation explanation = context.searcher().explain(context.query(), topLevelDocId);
            for (RescoreContext rescore : context.rescore()) {
                explanation = rescore.rescorer().explain(topLevelDocId, context.searcher(), rescore, explanation);
            }
            hitContext.hit().explanation(explanation);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to explain doc [" + hitContext.hit().getType() + "#" + hitContext.hit().getId() + "]", (Throwable)e);
        }
        finally {
            context.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }
}

