/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.profile;

import conductor.org.elasticsearch.search.profile.Timer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProfileBreakdown<T extends Enum<T>> {
    private final Timer[] timings;
    private final T[] timingTypes;

    public AbstractProfileBreakdown(Class<T> clazz) {
        this.timingTypes = (Enum[])clazz.getEnumConstants();
        this.timings = new Timer[this.timingTypes.length];
        for (int i = 0; i < this.timings.length; ++i) {
            this.timings[i] = new Timer();
        }
    }

    public Timer getTimer(T timing) {
        return this.timings[((Enum)timing).ordinal()];
    }

    public void setTimer(T timing, Timer timer) {
        this.timings[((Enum)timing).ordinal()] = timer;
    }

    public Map<String, Long> toTimingMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (T timingType : this.timingTypes) {
            map.put(((Enum)timingType).toString(), this.timings[((Enum)timingType).ordinal()].getApproximateTiming());
            map.put(((Enum)timingType).toString() + "_count", this.timings[((Enum)timingType).ordinal()].getCount());
        }
        return Collections.unmodifiableMap(map);
    }
}

