/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.phrase;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.suggest.phrase.LaplaceScorer;
import conductor.org.elasticsearch.search.suggest.phrase.SmoothingModel;
import conductor.org.elasticsearch.search.suggest.phrase.WordScorer;
import java.io.IOException;
import java.util.Objects;

public final class Laplace
extends SmoothingModel {
    public static final String NAME = "laplace";
    private static final ParseField ALPHA_FIELD = new ParseField("alpha", new String[0]);
    static final ParseField PARSE_FIELD = new ParseField("laplace", new String[0]);
    public static final double DEFAULT_LAPLACE_ALPHA = 0.5;
    private double alpha = 0.5;

    public Laplace(double alpha) {
        this.alpha = alpha;
    }

    public Laplace(StreamInput in) throws IOException {
        this.alpha = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.alpha);
    }

    public double getAlpha() {
        return this.alpha;
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ALPHA_FIELD.getPreferredName(), this.alpha);
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(SmoothingModel other) {
        Laplace otherModel = (Laplace)other;
        return Objects.equals(this.alpha, otherModel.alpha);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.alpha);
    }

    public static SmoothingModel fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        double alpha = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            }
            if (!token.isValue() || !ALPHA_FIELD.match(fieldName, parser.getDeprecationHandler())) continue;
            alpha = parser.doubleValue();
        }
        return new Laplace(alpha);
    }

    @Override
    public WordScorer.WordScorerFactory buildWordScorerFactory() {
        return (reader, terms, field, realWordLikelyhood, separator) -> new LaplaceScorer(reader, terms, field, realWordLikelyhood, separator, this.alpha);
    }
}

