/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.phrase;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import conductor.org.elasticsearch.search.suggest.phrase.WordScorer;
import java.io.IOException;

final class LaplaceScorer
extends WordScorer {
    private double alpha;

    LaplaceScorer(IndexReader reader, Terms terms, String field, double realWordLikelyhood, BytesRef separator, double alpha) throws IOException {
        super(reader, terms, field, realWordLikelyhood, separator);
        this.alpha = alpha;
    }

    double alpha() {
        return this.alpha;
    }

    @Override
    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        LaplaceScorer.join(this.separator, this.spare, w_1.term, word.term);
        return (this.alpha + (double)this.frequency(this.spare.get())) / (this.alpha + (double)w_1.frequency + (double)this.vocabluarySize);
    }

    @Override
    protected double scoreTrigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        LaplaceScorer.join(this.separator, this.spare, w_2.term, w_1.term, word.term);
        long trigramCount = this.frequency(this.spare.get());
        LaplaceScorer.join(this.separator, this.spare, w_1.term, word.term);
        return (this.alpha + (double)trigramCount) / (this.alpha + (double)this.frequency(this.spare.get()) + (double)this.vocabluarySize);
    }
}

