/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.bootstrap.Bootstrap;
import conductor.io.netty.bootstrap.ServerBootstrap;
import conductor.io.netty.channel.AdaptiveRecvByteBufAllocator;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelFuture;
import conductor.io.netty.channel.ChannelHandler;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.channel.ChannelInitializer;
import conductor.io.netty.channel.ChannelOption;
import conductor.io.netty.channel.FixedRecvByteBufAllocator;
import conductor.io.netty.channel.RecvByteBufAllocator;
import conductor.io.netty.channel.nio.NioEventLoopGroup;
import conductor.io.netty.channel.socket.nio.NioServerSocketChannel;
import conductor.io.netty.channel.socket.nio.NioSocketChannel;
import conductor.io.netty.util.AttributeKey;
import conductor.io.netty.util.concurrent.Future;
import conductor.io.netty.util.concurrent.GenericFutureListener;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.network.NetworkService;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.ByteSizeUnit;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import conductor.org.elasticsearch.common.util.concurrent.EsExecutors;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TcpTransport;
import conductor.org.elasticsearch.transport.netty4.ESLoggingHandler;
import conductor.org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import conductor.org.elasticsearch.transport.netty4.Netty4SizeHeaderFrameDecoder;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import conductor.org.elasticsearch.transport.netty4.NettyTcpChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Netty4Transport
extends TcpTransport {
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int workerCount;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    private volatile Bootstrap clientBootstrap;
    private final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    static final AttributeKey<NettyTcpChannel> CHANNEL_KEY;

    public Netty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        Netty4Utils.setAvailableProcessors(EsExecutors.PROCESSORS_SETTING.get(settings));
        this.workerCount = WORKER_COUNT.get(settings);
        this.receivePredictorMin = NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            this.clientBootstrap = this.createClientBootstrap();
            if (NetworkService.NETWORK_SERVER.get(this.settings).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.createServerBootstrap(profileSettings);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createClientBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory(this.settings, "transport_client_boss")));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Boolean)TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Boolean)TCP_KEEP_ALIVE.get(this.settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, reuseAddress);
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings) {
        String name = profileSettings.profileName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], receive_predictor[{}->{}]", (Object)name, (Object)this.workerCount, (Object)profileSettings.portOrRange, (Object)profileSettings.bindHosts, (Object)profileSettings.publishHosts, (Object)this.compress, (Object)this.receivePredictorMin, (Object)this.receivePredictorMax);
        }
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker", name);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(new NioEventLoopGroup(this.workerCount, workerFactory));
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, profileSettings.tcpKeepAlive);
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new ClientChannelInitializer();
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable unwrapped = ExceptionsHelper.unwrap(cause, ElasticsearchException.class);
        Throwable t = unwrapped != null ? unwrapped : cause;
        Channel channel = ctx.channel();
        this.onException(channel.attr(CHANNEL_KEY).get(), t instanceof Exception ? (Exception)t : new ElasticsearchException(t));
    }

    @Override
    protected NettyTcpChannel initiateChannel(DiscoveryNode node, ActionListener<Void> listener) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        Bootstrap bootstrapWithHandler = this.clientBootstrap.clone();
        bootstrapWithHandler.handler(this.getClientChannelInitializer(node));
        bootstrapWithHandler.remoteAddress(address);
        ChannelFuture channelFuture = bootstrapWithHandler.connect();
        Channel channel = channelFuture.channel();
        if (channel == null) {
            ExceptionsHelper.maybeDieOnAnotherThread(channelFuture.cause());
            throw new IOException(channelFuture.cause());
        }
        this.addClosedExceptionLogger(channel);
        NettyTcpChannel nettyChannel = new NettyTcpChannel(channel);
        channel.attr(CHANNEL_KEY).set(nettyChannel);
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        }));
        return nettyChannel;
    }

    @Override
    protected NettyTcpChannel bind(String name, InetSocketAddress address) {
        Channel channel = this.serverBootstraps.get(name).bind(address).syncUninterruptibly().channel();
        NettyTcpChannel esChannel = new NettyTcpChannel(channel);
        channel.attr(CHANNEL_KEY).set(esChannel);
        return esChannel;
    }

    long successfulPingCount() {
        return this.successfulPings.count();
    }

    long failedPingCount() {
        return this.failedPings.count();
    }

    @Override
    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasables.close(() -> {
            ArrayList serverBootstrapCloseFutures = new ArrayList(this.serverBootstraps.size());
            for (Map.Entry<String, ServerBootstrap> entry : this.serverBootstraps.entrySet()) {
                serverBootstrapCloseFutures.add(Tuple.tuple(entry.getKey(), entry.getValue().config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS)));
            }
            for (Tuple tuple : serverBootstrapCloseFutures) {
                ((Future)tuple.v2()).awaitUninterruptibly();
                if (((Future)tuple.v2()).isSuccess()) continue;
                this.logger.debug(() -> new ParameterizedMessage("Error closing server bootstrap for profile [{}]", future.v1()), ((Future)tuple.v2()).cause());
            }
            this.serverBootstraps.clear();
            if (this.clientBootstrap != null) {
                this.clientBootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
                this.clientBootstrap = null;
            }
        });
    }

    private void addClosedExceptionLogger(Channel channel) {
        channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (!f.isSuccess()) {
                this.logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), f.cause());
            }
        }));
    }

    static {
        Netty4Utils.setup();
        WORKER_COUNT = new Setting<Integer>("transport.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors(s) * 2), s -> Setting.parseInt(s, 1, "transport.netty.worker_count"), Setting.Property.NodeScope);
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("transport.netty.receive_predictor_size", new ByteSizeValue(64L, ByteSizeUnit.KB), Setting.Property.NodeScope);
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting("transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting("transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
        NETTY_BOSS_COUNT = Setting.intSetting("transport.netty.boss_count", 1, 1, Setting.Property.NodeScope);
        CHANNEL_KEY = AttributeKey.newInstance("es-channel");
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.this.addClosedExceptionLogger(ch);
            NettyTcpChannel nettyTcpChannel = new NettyTcpChannel(ch);
            ch.attr(CHANNEL_KEY).set(nettyTcpChannel);
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, this.name));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, ".client"));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

