/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.nio.protocol;

import conductor.org.apache.http.HttpException;
import conductor.org.apache.http.HttpRequest;
import conductor.org.apache.http.annotation.Contract;
import conductor.org.apache.http.annotation.ThreadingBehavior;
import conductor.org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import conductor.org.apache.http.nio.protocol.HttpAsyncExchange;
import conductor.org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import conductor.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import conductor.org.apache.http.protocol.HttpContext;
import conductor.org.apache.http.protocol.HttpRequestHandler;
import conductor.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

