/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.payloads;

import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.payloads.PayloadHelper;
import conductor.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;

public class NumericPayloadTokenFilter
extends TokenFilter {
    private String typeMatch;
    private BytesRef thePayload;
    private final PayloadAttribute payloadAtt = this.addAttribute(PayloadAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public NumericPayloadTokenFilter(TokenStream input, float payload, String typeMatch) {
        super(input);
        if (typeMatch == null) {
            throw new IllegalArgumentException("typeMatch must not be null");
        }
        this.thePayload = new BytesRef(PayloadHelper.encodeFloat(payload));
        this.typeMatch = typeMatch;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.typeAtt.type().equals(this.typeMatch)) {
                this.payloadAtt.setPayload(this.thePayload);
            }
            return true;
        }
        return false;
    }
}

