/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.geo.parsers;

import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.geo.builders.ShapeBuilder;
import conductor.org.elasticsearch.common.geo.parsers.GeoJsonParser;
import conductor.org.elasticsearch.common.geo.parsers.GeoWKTParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import java.io.IOException;

public interface ShapeParser {
    public static final ParseField FIELD_TYPE = new ParseField("type", new String[0]);
    public static final ParseField FIELD_COORDINATES = new ParseField("coordinates", new String[0]);
    public static final ParseField FIELD_GEOMETRIES = new ParseField("geometries", new String[0]);
    public static final ParseField FIELD_ORIENTATION = new ParseField("orientation", new String[0]);

    public static ShapeBuilder parse(XContentParser parser, GeoShapeFieldMapper shapeMapper) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return GeoJsonParser.parse(parser, shapeMapper);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return GeoWKTParser.parse(parser, shapeMapper);
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }

    public static ShapeBuilder parse(XContentParser parser) throws IOException {
        return ShapeParser.parse(parser, null);
    }
}

