/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.lucene.analysis.Tokenizer;
import conductor.org.apache.lucene.analysis.standard.StandardTokenizer;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class StandardTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    public StandardTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.maxTokenLength = settings.getAsInt("max_token_length", 255);
    }

    @Override
    public Tokenizer create() {
        StandardTokenizer tokenizer = new StandardTokenizer();
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

