/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.util.Objects;

public class SourceToParse {
    private final BytesReference source;
    private final String index;
    private final String type;
    private final String id;
    private String routing;
    private String parentId;
    private XContentType xContentType;

    public static SourceToParse source(String index, String type, String id, BytesReference source, XContentType contentType) {
        return new SourceToParse(index, type, id, source, contentType);
    }

    private SourceToParse(String index, String type, String id, BytesReference source, XContentType xContentType) {
        this.index = Objects.requireNonNull(index);
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
        this.source = new BytesArray(Objects.requireNonNull(source).toBytesRef());
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public BytesReference source() {
        return this.source;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String parent() {
        return this.parentId;
    }

    public SourceToParse parent(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public SourceToParse routing(String routing) {
        this.routing = routing;
        return this;
    }

    public static enum Origin {
        PRIMARY,
        REPLICA;

    }
}

