/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.rankeval;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.MultiSearchRequest;
import conductor.org.elasticsearch.action.search.MultiSearchResponse;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.HandledTransportAction;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.rankeval.EvalQueryQuality;
import conductor.org.elasticsearch.index.rankeval.EvaluationMetric;
import conductor.org.elasticsearch.index.rankeval.RankEvalRequest;
import conductor.org.elasticsearch.index.rankeval.RankEvalResponse;
import conductor.org.elasticsearch.index.rankeval.RankEvalSpec;
import conductor.org.elasticsearch.index.rankeval.RatedRequest;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.script.TemplateScript;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.builder.SearchSourceBuilder;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TransportRankEvalAction
extends HandledTransportAction<RankEvalRequest, RankEvalResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportRankEvalAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, TransportService transportService, ScriptService scriptService, NamedXContentRegistry namedXContentRegistry) {
        super(settings, "indices:data/read/rank_eval", threadPool, transportService, actionFilters, RankEvalRequest::new, indexNameExpressionResolver);
        this.scriptService = scriptService;
        this.namedXContentRegistry = namedXContentRegistry;
        this.client = client;
    }

    @Override
    protected void doExecute(RankEvalRequest request, ActionListener<RankEvalResponse> listener) {
        RankEvalSpec evaluationSpecification = request.getRankEvalSpec();
        EvaluationMetric metric = evaluationSpecification.getMetric();
        List<RatedRequest> ratedRequests = evaluationSpecification.getRatedRequests();
        ConcurrentHashMap<String, Exception> errors = new ConcurrentHashMap<String, Exception>(ratedRequests.size());
        HashMap<String, TemplateScript.Factory> scriptsWithoutParams = new HashMap<String, TemplateScript.Factory>();
        for (Map.Entry<String, Script> entry : evaluationSpecification.getTemplates().entrySet()) {
            scriptsWithoutParams.put(entry.getKey(), this.scriptService.compile(entry.getValue(), TemplateScript.CONTEXT));
        }
        MultiSearchRequest msearchRequest = new MultiSearchRequest();
        msearchRequest.maxConcurrentSearchRequests(evaluationSpecification.getMaxConcurrentSearches());
        ArrayList<RatedRequest> ratedRequestsInSearch = new ArrayList<RatedRequest>();
        for (RatedRequest ratedRequest : ratedRequests) {
            SearchSourceBuilder evaluationRequest = ratedRequest.getEvaluationRequest();
            if (evaluationRequest == null) {
                Map<String, Object> params = ratedRequest.getParams();
                String templateId = ratedRequest.getTemplateId();
                TemplateScript.Factory templateScript = (TemplateScript.Factory)scriptsWithoutParams.get(templateId);
                String resolvedRequest = templateScript.newInstance(params).execute();
                try (XContentParser subParser = XContentHelper.createParser(this.namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, new BytesArray(resolvedRequest), XContentType.JSON);){
                    evaluationRequest = SearchSourceBuilder.fromXContent(subParser, false);
                    RatedRequest.validateEvaluatedQuery(evaluationRequest);
                }
                catch (IOException e) {
                    errors.put(ratedRequest.getId(), e);
                    continue;
                }
            }
            if (metric.forcedSearchSize().isPresent()) {
                evaluationRequest.size(metric.forcedSearchSize().get());
            }
            ratedRequestsInSearch.add(ratedRequest);
            List<String> summaryFields = ratedRequest.getSummaryFields();
            if (summaryFields.isEmpty()) {
                evaluationRequest.fetchSource(false);
            } else {
                evaluationRequest.fetchSource(summaryFields.toArray(new String[summaryFields.size()]), new String[0]);
            }
            SearchRequest searchRequest = new SearchRequest(request.indices(), evaluationRequest);
            searchRequest.indicesOptions(request.indicesOptions());
            msearchRequest.add(searchRequest);
        }
        assert (ratedRequestsInSearch.size() == msearchRequest.requests().size());
        this.client.multiSearch(msearchRequest, new RankEvalActionListener(listener, metric, ratedRequestsInSearch.toArray(new RatedRequest[ratedRequestsInSearch.size()]), errors));
    }

    class RankEvalActionListener
    implements ActionListener<MultiSearchResponse> {
        private final ActionListener<RankEvalResponse> listener;
        private final RatedRequest[] specifications;
        private final Map<String, Exception> errors;
        private final EvaluationMetric metric;

        RankEvalActionListener(ActionListener<RankEvalResponse> listener, EvaluationMetric metric, RatedRequest[] specifications, Map<String, Exception> errors) {
            this.listener = listener;
            this.metric = metric;
            this.errors = errors;
            this.specifications = specifications;
        }

        @Override
        public void onResponse(MultiSearchResponse multiSearchResponse) {
            int responsePosition = 0;
            HashMap<String, EvalQueryQuality> responseDetails = new HashMap<String, EvalQueryQuality>(this.specifications.length);
            for (MultiSearchResponse.Item response : multiSearchResponse.getResponses()) {
                RatedRequest specification = this.specifications[responsePosition];
                if (!response.isFailure()) {
                    SearchHit[] hits = response.getResponse().getHits().getHits();
                    EvalQueryQuality queryQuality = this.metric.evaluate(specification.getId(), hits, specification.getRatedDocs());
                    responseDetails.put(specification.getId(), queryQuality);
                } else {
                    this.errors.put(specification.getId(), response.getFailure());
                }
                ++responsePosition;
            }
            this.listener.onResponse(new RankEvalResponse(this.metric.combine(responseDetails.values()), responseDetails, this.errors));
        }

        @Override
        public void onFailure(Exception exception) {
            this.listener.onFailure(exception);
        }
    }
}

