/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.process;

import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.SingleObjectCache;
import conductor.org.elasticsearch.monitor.process.ProcessInfo;
import conductor.org.elasticsearch.monitor.process.ProcessProbe;
import conductor.org.elasticsearch.monitor.process.ProcessStats;

public final class ProcessService
extends AbstractComponent {
    private final ProcessProbe probe = ProcessProbe.getInstance();
    private final ProcessInfo info;
    private final SingleObjectCache<ProcessStats> processStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.process.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public ProcessService(Settings settings) {
        super(settings);
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.processStatsCache = new ProcessStatsCache(refreshInterval, this.probe.processStats());
        this.info = this.probe.processInfo(refreshInterval.millis());
        this.logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public ProcessInfo info() {
        return this.info;
    }

    public ProcessStats stats() {
        return this.processStatsCache.getOrRefresh();
    }

    private class ProcessStatsCache
    extends SingleObjectCache<ProcessStats> {
        ProcessStatsCache(TimeValue interval, ProcessStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected ProcessStats refresh() {
            return ProcessService.this.probe.processStats();
        }
    }
}

