/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.percolator;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.ReaderUtil;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.BoostQuery;
import conductor.org.apache.lucene.search.ConstantScoreQuery;
import conductor.org.apache.lucene.search.DisjunctionMaxQuery;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.document.DocumentField;
import conductor.org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.text.Text;
import conductor.org.elasticsearch.index.query.ParsedQuery;
import conductor.org.elasticsearch.percolator.PercolateQuery;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.internal.SubSearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class PercolatorHighlightSubFetchPhase
implements FetchSubPhase {
    private final HighlightPhase highlightPhase;

    PercolatorHighlightSubFetchPhase(Settings settings, Map<String, Highlighter> highlighters) {
        this.highlightPhase = new HighlightPhase(settings, highlighters);
    }

    boolean hitsExecutionNeeded(SearchContext context) {
        return context.highlight() != null && !PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query()).isEmpty();
    }

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!this.hitsExecutionNeeded(context)) {
            return;
        }
        List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query());
        if (percolateQueries.isEmpty()) {
            throw new IllegalStateException("couldn't locate percolator query");
        }
        boolean singlePercolateQuery = percolateQueries.size() == 1;
        for (PercolateQuery percolateQuery : percolateQueries) {
            String fieldName = singlePercolateQuery ? "_percolator_document_slot" : "_percolator_document_slot_" + percolateQuery.getName();
            List<LeafReaderContext> ctxs = context.searcher().getIndexReader().leaves();
            IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
            PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
            LeafReaderContext percolatorLeafReaderContext = percolatorIndexSearcher.getIndexReader().leaves().get(0);
            FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
            for (SearchHit hit : hits) {
                DocumentField field;
                LeafReaderContext ctx = ctxs.get(ReaderUtil.subIndex(hit.docId(), ctxs));
                int segmentDocId = hit.docId() - ctx.docBase;
                Query query = queryStore.getQueries(ctx).apply(segmentDocId);
                if (query == null || (field = hit.field(fieldName)) == null) continue;
                for (Object matchedSlot : field.getValues()) {
                    int slot = (Integer)matchedSlot;
                    BytesReference document = percolateQuery.getDocuments().get(slot);
                    SubSearchContext subSearchContext = this.createSubSearchContext(context, percolatorLeafReaderContext, document, slot);
                    subSearchContext.parsedQuery(new ParsedQuery(query));
                    hitContext.reset(new SearchHit(slot, "unknown", new Text(hit.getType()), Collections.emptyMap()), percolatorLeafReaderContext, slot, percolatorIndexSearcher);
                    hitContext.cache().clear();
                    this.highlightPhase.hitExecute(subSearchContext, hitContext);
                    for (Map.Entry<String, HighlightField> entry : hitContext.hit().getHighlightFields().entrySet()) {
                        String hlFieldName;
                        if (percolateQuery.getDocuments().size() == 1) {
                            hlFieldName = singlePercolateQuery ? entry.getKey() : percolateQuery.getName() + "_" + entry.getKey();
                            hit.getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, entry.getValue().fragments()));
                            continue;
                        }
                        hlFieldName = singlePercolateQuery ? slot + "_" + entry.getKey() : percolateQuery.getName() + "_" + slot + "_" + entry.getKey();
                        hit.getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, entry.getValue().fragments()));
                    }
                }
            }
        }
    }

    static List<PercolateQuery> locatePercolatorQuery(Query query) {
        if (query instanceof PercolateQuery) {
            return Collections.singletonList((PercolateQuery)query);
        }
        if (query instanceof BooleanQuery) {
            ArrayList<PercolateQuery> percolateQueries = new ArrayList<PercolateQuery>();
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                List<PercolateQuery> result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(clause.getQuery());
                if (result.isEmpty()) continue;
                percolateQueries.addAll(result);
            }
            return percolateQueries;
        }
        if (query instanceof DisjunctionMaxQuery) {
            ArrayList<PercolateQuery> percolateQueries = new ArrayList<PercolateQuery>();
            for (Query disjunct : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                List<PercolateQuery> result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(disjunct);
                if (result.isEmpty()) continue;
                percolateQueries.addAll(result);
            }
            return percolateQueries;
        }
        if (query instanceof ConstantScoreQuery) {
            return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((ConstantScoreQuery)query).getQuery());
        }
        if (query instanceof BoostQuery) {
            return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((BoostQuery)query).getQuery());
        }
        if (query instanceof FunctionScoreQuery) {
            return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((FunctionScoreQuery)query).getSubQuery());
        }
        return Collections.emptyList();
    }

    private SubSearchContext createSubSearchContext(SearchContext context, LeafReaderContext leafReaderContext, BytesReference source, int docId) {
        SubSearchContext subSearchContext = new SubSearchContext(context);
        subSearchContext.highlight(new SearchContextHighlight(context.highlight().fields()));
        subSearchContext.highlight().globalForceSource(true);
        subSearchContext.lookup().source().setSegmentAndDocument(leafReaderContext, docId);
        subSearchContext.lookup().source().setSource(source);
        return subSearchContext;
    }
}

