/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.com.carrotsearch.hppc.cursors.ObjectCursor;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import conductor.org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.indices.TypeMissingException;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.SortedSet;
import java.util.stream.Collectors;

public class RestGetMappingAction
extends BaseRestHandler {
    public RestGetMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mappings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}", this);
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getMappingsRequest.masterNodeTimeout()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestBuilderListener<GetMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                RestStatus status;
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsByIndex = response.getMappings();
                if (mappingsByIndex.isEmpty() && types.length != 0) {
                    builder.close();
                    return new BytesRestResponse(this.channel, new TypeMissingException("_all", String.join((CharSequence)",", types)));
                }
                HashSet<String> typeNames = new HashSet<String>();
                for (ObjectCursor<ImmutableOpenMap<String, MappingMetaData>> objectCursor : mappingsByIndex.values()) {
                    for (ObjectCursor inner : ((ImmutableOpenMap)objectCursor.value).keys()) {
                        typeNames.add((String)inner.value);
                    }
                }
                SortedSet<String> difference = Sets.sortedDifference(Arrays.stream(types).collect(Collectors.toSet()), typeNames);
                ArrayList<String> arrayList = new ArrayList<String>();
                block2: for (String pattern : difference) {
                    if (!pattern.contains("*")) continue;
                    for (String typeName : typeNames) {
                        if (!Regex.simpleMatch(pattern, typeName)) continue;
                        arrayList.add(pattern);
                        continue block2;
                    }
                }
                difference.removeAll(arrayList);
                builder.startObject();
                if (difference.isEmpty()) {
                    status = RestStatus.OK;
                } else {
                    status = RestStatus.NOT_FOUND;
                    String message = String.format(Locale.ROOT, "type" + (difference.size() == 1 ? "" : "s") + " [%s] missing", Strings.collectionToCommaDelimitedString(difference));
                    builder.field("error", message);
                    builder.field("status", status.getStatus());
                }
                response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

