/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.filter;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class FiltersAggregator
extends BucketsAggregator {
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    public static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    public static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    private final String[] keys;
    private Supplier<Weight[]> filters;
    private final boolean keyed;
    private final boolean showOtherBucket;
    private final String otherBucketKey;
    private final int totalNumKeys;

    public FiltersAggregator(String name, AggregatorFactories factories, String[] keys, Supplier<Weight[]> filters, boolean keyed, String otherBucketKey, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.keyed = keyed;
        this.keys = keys;
        this.filters = filters;
        this.showOtherBucket = otherBucketKey != null;
        this.otherBucketKey = otherBucketKey;
        this.totalNumKeys = this.showOtherBucket ? keys.length + 1 : keys.length;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        Weight[] filters = this.filters.get();
        final Bits[] bits = new Bits[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            bits[i] = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), filters[i].scorerSupplier(ctx));
        }
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                boolean matched = false;
                for (int i = 0; i < bits.length; ++i) {
                    if (!bits[i].get(doc)) continue;
                    FiltersAggregator.this.collectBucket(sub, doc, FiltersAggregator.this.bucketOrd(bucket, i));
                    matched = true;
                }
                if (FiltersAggregator.this.showOtherBucket && !matched) {
                    FiltersAggregator.this.collectBucket(sub, doc, FiltersAggregator.this.bucketOrd(bucket, bits.length));
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        this.consumeBucketsAndMaybeBreak(this.keys.length + (this.showOtherBucket ? 1 : 0));
        ArrayList<InternalFilters.InternalBucket> buckets = new ArrayList<InternalFilters.InternalBucket>(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            long bucketOrd = this.bucketOrd(owningBucketOrdinal, i);
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.keys[i], this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.keyed);
            buckets.add(bucket);
        }
        if (this.showOtherBucket) {
            long bucketOrd = this.bucketOrd(owningBucketOrdinal, this.keys.length);
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.otherBucketKey, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.InternalBucket> buckets = new ArrayList<InternalFilters.InternalBucket>(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.keys[i], 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        if (this.showOtherBucket) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.otherBucketKey, 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
        return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
    }

    public static class KeyedFilter
    implements Writeable,
    ToXContentFragment {
        private final String key;
        private final QueryBuilder filter;

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = in.readNamedWriteable(QueryBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable(this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

