/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.weighted_avg;

import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.metrics.weighted_avg.WeightedAvgAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.MultiValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class WeightedAvgAggregatorFactory
extends MultiValuesSourceAggregatorFactory<ValuesSource.Numeric, WeightedAvgAggregatorFactory> {
    public WeightedAvgAggregatorFactory(String name, Map<String, ValuesSourceConfig<ValuesSource.Numeric>> configs, DocValueFormat format, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, configs, format, context, parent, subFactoriesBuilder, metaData);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new WeightedAvgAggregator(this.name, null, this.format, this.context, parent, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator doCreateInternal(Map<String, ValuesSourceConfig<ValuesSource.Numeric>> configs, DocValueFormat format, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs, this.context.getQueryShardContext());
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(parent, pipelineAggregators, metaData);
        }
        return new WeightedAvgAggregator(this.name, numericMultiVS, format, this.context, parent, pipelineAggregators, metaData);
    }
}

