/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.Aggregations;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import conductor.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.AggregationPath;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BucketMetricsPipelineAggregator
extends SiblingPipelineAggregator {
    protected final DocValueFormat format;
    protected final BucketHelpers.GapPolicy gapPolicy;

    protected BucketMetricsPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metaData) {
        super(name, bucketsPaths, metaData);
        this.gapPolicy = gapPolicy;
        this.format = format;
    }

    protected BucketMetricsPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    public final void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        this.gapPolicy.writeTo(out);
        this.innerWriteTo(out);
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    public final InternalAggregation doReduce(Aggregations aggregations, InternalAggregation.ReduceContext context) {
        this.preCollection();
        List<String> bucketsPath = AggregationPath.parse(this.bucketsPaths()[0]).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(bucketsPath.get(0))) continue;
            List<String> sublistedPath = bucketsPath.subList(1, bucketsPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List<InternalMultiBucketAggregation.InternalBucket> buckets = multiBucketsAgg.getBuckets();
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, bucket, sublistedPath, this.gapPolicy);
                if (bucketValue == null || Double.isNaN(bucketValue)) continue;
                this.collectBucketValue(bucket.getKeyAsString(), bucketValue);
            }
        }
        return this.buildAggregation(Collections.emptyList(), this.metaData());
    }

    protected void preCollection() {
    }

    protected abstract InternalAggregation buildAggregation(List<PipelineAggregator> var1, Map<String, Object> var2);

    protected abstract void collectBucketValue(String var1, Double var2);
}

