/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.phrase;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.MultiFields;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.spell.DirectSpellChecker;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.apache.lucene.util.CharsRefBuilder;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.text.Text;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.query.AbstractQueryBuilder;
import conductor.org.elasticsearch.index.query.ParsedQuery;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.script.TemplateScript;
import conductor.org.elasticsearch.search.suggest.Suggest;
import conductor.org.elasticsearch.search.suggest.Suggester;
import conductor.org.elasticsearch.search.suggest.SuggestionSearchContext;
import conductor.org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import conductor.org.elasticsearch.search.suggest.phrase.Correction;
import conductor.org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import conductor.org.elasticsearch.search.suggest.phrase.MultiCandidateGeneratorWrapper;
import conductor.org.elasticsearch.search.suggest.phrase.NoisyChannelSpellChecker;
import conductor.org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import conductor.org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import conductor.org.elasticsearch.search.suggest.phrase.WordScorer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class PhraseSuggester
extends Suggester<PhraseSuggestionContext> {
    private final BytesRef SEPARATOR = new BytesRef(" ");
    private static final String SUGGESTION_TEMPLATE_VAR_NAME = "suggestion";
    public static final PhraseSuggester INSTANCE = new PhraseSuggester();

    private PhraseSuggester() {
    }

    @Override
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, PhraseSuggestionContext suggestion, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        double realWordErrorLikelihood = suggestion.realworldErrorLikelyhood().floatValue();
        PhraseSuggestion response = new PhraseSuggestion(name, suggestion.getSize());
        IndexReader indexReader = searcher.getIndexReader();
        List<PhraseSuggestionContext.DirectCandidateGenerator> generators = suggestion.generators();
        int numGenerators = generators.size();
        ArrayList<DirectCandidateGenerator> gens = new ArrayList<DirectCandidateGenerator>(generators.size());
        for (int i = 0; i < numGenerators; ++i) {
            PhraseSuggestionContext.DirectCandidateGenerator generator = generators.get(i);
            DirectSpellChecker directSpellChecker = generator.createDirectSpellChecker();
            Terms terms = MultiFields.getTerms(indexReader, generator.field());
            if (terms == null) continue;
            gens.add(new DirectCandidateGenerator(directSpellChecker, generator.field(), generator.suggestMode(), indexReader, realWordErrorLikelihood, generator.size(), generator.preFilter(), generator.postFilter(), terms));
        }
        String suggestField = suggestion.getField();
        Terms suggestTerms = MultiFields.getTerms(indexReader, suggestField);
        if (gens.size() > 0 && suggestTerms != null) {
            NoisyChannelSpellChecker.Result checkerResult;
            NoisyChannelSpellChecker checker = new NoisyChannelSpellChecker(realWordErrorLikelihood, suggestion.getRequireUnigram(), suggestion.getTokenLimit());
            BytesRef separator = suggestion.separator();
            WordScorer wordScorer = suggestion.model().newScorer(indexReader, suggestTerms, suggestField, realWordErrorLikelihood, separator);
            try (TokenStream stream = checker.tokenStream(suggestion.getAnalyzer(), suggestion.getText(), spare, suggestion.getField());){
                checkerResult = checker.getCorrections(stream, new MultiCandidateGeneratorWrapper(suggestion.getShardSize(), gens.toArray(new CandidateGenerator[gens.size()])), suggestion.maxErrors(), suggestion.getShardSize(), wordScorer, suggestion.confidence(), suggestion.gramSize());
            }
            PhraseSuggestion.Entry resultEntry = PhraseSuggester.buildResultEntry(suggestion, spare, checkerResult.cutoffScore);
            response.addTerm(resultEntry);
            BytesRefBuilder byteSpare = new BytesRefBuilder();
            TemplateScript.Factory scriptFactory = suggestion.getCollateQueryScript();
            boolean collatePrune = scriptFactory != null && suggestion.collatePrune();
            for (int i = 0; i < checkerResult.corrections.length; ++i) {
                Correction correction = checkerResult.corrections[i];
                spare.copyUTF8Bytes(correction.join(this.SEPARATOR, byteSpare, null, null));
                boolean collateMatch = true;
                if (scriptFactory != null) {
                    Map<String, Object> vars = suggestion.getCollateScriptParams();
                    vars.put(SUGGESTION_TEMPLATE_VAR_NAME, spare.toString());
                    QueryShardContext shardContext = suggestion.getShardContext();
                    String querySource = scriptFactory.newInstance(vars).execute();
                    try (XContentParser parser = XContentFactory.xContent(querySource).createParser(shardContext.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, querySource);){
                        QueryBuilder innerQueryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
                        ParsedQuery parsedQuery = shardContext.toQuery(innerQueryBuilder);
                        collateMatch = Lucene.exists(searcher, parsedQuery.query());
                    }
                }
                if (!collateMatch && !collatePrune) continue;
                Text phrase = new Text(spare.toString());
                Text highlighted = null;
                if (suggestion.getPreTag() != null) {
                    spare.copyUTF8Bytes(correction.join(this.SEPARATOR, byteSpare, suggestion.getPreTag(), suggestion.getPostTag()));
                    highlighted = new Text(spare.toString());
                }
                if (collatePrune) {
                    resultEntry.addOption(new Suggest.Suggestion.Entry.Option(phrase, highlighted, (float)correction.score, collateMatch));
                    continue;
                }
                resultEntry.addOption(new Suggest.Suggestion.Entry.Option(phrase, highlighted, (float)correction.score));
            }
        } else {
            response.addTerm(PhraseSuggester.buildResultEntry(suggestion, spare, Double.MIN_VALUE));
        }
        return response;
    }

    private static PhraseSuggestion.Entry buildResultEntry(SuggestionSearchContext.SuggestionContext suggestion, CharsRefBuilder spare, double cutoffScore) {
        spare.copyUTF8Bytes(suggestion.getText());
        return new PhraseSuggestion.Entry(new Text(spare.toString()), 0, spare.length(), cutoffScore);
    }
}

