/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch;

import com.netflix.conductor.elasticsearch.ElasticSearchConfiguration;
import conductor.org.apache.http.HttpHost;
import conductor.org.elasticsearch.client.RestClient;
import conductor.org.elasticsearch.client.RestClientBuilder;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;

public class ElasticSearchRestClientBuilderProvider
implements Provider<RestClientBuilder> {
    private final ElasticSearchConfiguration configuration;

    @Inject
    public ElasticSearchRestClientBuilderProvider(ElasticSearchConfiguration configuration) {
        this.configuration = configuration;
    }

    public RestClientBuilder get() {
        return RestClient.builder(this.convertToHttpHosts(this.configuration.getURIs()));
    }

    private HttpHost[] convertToHttpHosts(List<URI> hosts) {
        List<HttpHost> list = hosts.stream().map(host -> new HttpHost(host.getHost(), host.getPort(), host.getScheme())).collect(Collectors.toList());
        return list.toArray(new HttpHost[list.size()]);
    }
}

