/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.FieldType;
import conductor.org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.DocValuesType;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.search.Query;
import java.io.IOException;

public class NumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public NumericDocValuesField(String name, long value) {
        this(name, (Long)value);
    }

    public NumericDocValuesField(String name, Long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                NumericDocValues values = reader.getNumericDocValues(field);
                if (values == null) {
                    return null;
                }
                return DocValues.singleton(values);
            }
        };
    }

    public static Query newSlowExactQuery(String field, long value) {
        return NumericDocValuesField.newSlowRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.NUMERIC);
        TYPE.freeze();
    }
}

