/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.search.DocIdSetIterator;
import java.io.IOException;
import java.util.Objects;

public abstract class TwoPhaseIterator {
    protected final DocIdSetIterator approximation;

    protected TwoPhaseIterator(DocIdSetIterator approximation) {
        this.approximation = Objects.requireNonNull(approximation);
    }

    public static DocIdSetIterator asDocIdSetIterator(TwoPhaseIterator twoPhaseIterator) {
        return new TwoPhaseIteratorAsDocIdSetIterator(twoPhaseIterator);
    }

    public static TwoPhaseIterator unwrap(DocIdSetIterator iterator) {
        if (iterator instanceof TwoPhaseIteratorAsDocIdSetIterator) {
            return ((TwoPhaseIteratorAsDocIdSetIterator)iterator).twoPhaseIterator;
        }
        return null;
    }

    public DocIdSetIterator approximation() {
        return this.approximation;
    }

    public abstract boolean matches() throws IOException;

    public abstract float matchCost();

    private static class TwoPhaseIteratorAsDocIdSetIterator
    extends DocIdSetIterator {
        final TwoPhaseIterator twoPhaseIterator;
        final DocIdSetIterator approximation;

        TwoPhaseIteratorAsDocIdSetIterator(TwoPhaseIterator twoPhaseIterator) {
            this.twoPhaseIterator = twoPhaseIterator;
            this.approximation = twoPhaseIterator.approximation;
        }

        @Override
        public int docID() {
            return this.approximation.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.doNext(this.approximation.nextDoc());
        }

        @Override
        public int advance(int target) throws IOException {
            return this.doNext(this.approximation.advance(target));
        }

        private int doNext(int doc) throws IOException {
            while (doc != Integer.MAX_VALUE) {
                if (this.twoPhaseIterator.matches()) {
                    return doc;
                }
                doc = this.approximation.nextDoc();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return this.approximation.cost();
        }
    }
}

