/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.similarities;

import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.similarities.BasicStats;
import conductor.org.apache.lucene.search.similarities.LMSimilarity;
import java.util.List;
import java.util.Locale;

public class LMDirichletSimilarity
extends LMSimilarity {
    private final float mu;

    public LMDirichletSimilarity(LMSimilarity.CollectionModel collectionModel, float mu) {
        super(collectionModel);
        this.mu = mu;
    }

    public LMDirichletSimilarity(float mu) {
        this.mu = mu;
    }

    public LMDirichletSimilarity(LMSimilarity.CollectionModel collectionModel) {
        this(collectionModel, 2000.0f);
    }

    public LMDirichletSimilarity() {
        this(2000.0f);
    }

    @Override
    protected float score(BasicStats stats, float freq, float docLen) {
        float score = stats.getBoost() * (float)(Math.log(1.0f + freq / (this.mu * ((LMSimilarity.LMStats)stats).getCollectionProbability())) + Math.log(this.mu / (docLen + this.mu)));
        return score > 0.0f ? score : 0.0f;
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, int doc, float freq, float docLen) {
        if (stats.getBoost() != 1.0f) {
            subs.add(Explanation.match(stats.getBoost(), "boost", new Explanation[0]));
        }
        subs.add(Explanation.match(this.mu, "mu", new Explanation[0]));
        Explanation weightExpl = Explanation.match((float)Math.log(1.0f + freq / (this.mu * ((LMSimilarity.LMStats)stats).getCollectionProbability())), "term weight", new Explanation[0]);
        subs.add(weightExpl);
        subs.add(Explanation.match((float)Math.log(this.mu / (docLen + this.mu)), "document norm", new Explanation[0]));
        super.explain(subs, stats, doc, freq, docLen);
    }

    public float getMu() {
        return this.mu;
    }

    @Override
    public String getName() {
        return String.format(Locale.ROOT, "Dirichlet(%f)", Float.valueOf(this.getMu()));
    }
}

