/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.document;

import conductor.org.apache.lucene.search.suggest.document.NRTSuggester;
import conductor.org.apache.lucene.store.IndexInput;
import conductor.org.apache.lucene.util.Accountable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public final class CompletionsTermsReader
implements Accountable {
    public final long minWeight;
    public final long maxWeight;
    public final byte type;
    private final IndexInput dictIn;
    private final long offset;
    private NRTSuggester suggester;

    CompletionsTermsReader(IndexInput dictIn, long offset, long minWeight, long maxWeight, byte type) throws IOException {
        assert (minWeight <= maxWeight);
        assert (offset >= 0L && offset < dictIn.length());
        this.dictIn = dictIn;
        this.offset = offset;
        this.minWeight = minWeight;
        this.maxWeight = maxWeight;
        this.type = type;
    }

    public synchronized NRTSuggester suggester() throws IOException {
        if (this.suggester == null) {
            try (IndexInput dictClone = this.dictIn.clone();){
                dictClone.seek(this.offset);
                this.suggester = NRTSuggester.load(dictClone);
            }
        }
        return this.suggester;
    }

    @Override
    public long ramBytesUsed() {
        return this.suggester != null ? this.suggester.ramBytesUsed() : 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }
}

