/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.reload;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import conductor.org.elasticsearch.action.support.nodes.TransportNodesAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.KeyStoreWrapper;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.plugins.PluginsService;
import conductor.org.elasticsearch.plugins.ReloadablePlugin;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TransportNodesReloadSecureSettingsAction
extends TransportNodesAction<NodesReloadSecureSettingsRequest, NodesReloadSecureSettingsResponse, NodeRequest, NodesReloadSecureSettingsResponse.NodeResponse> {
    private final Environment environment;
    private final PluginsService pluginsService;

    @Inject
    public TransportNodesReloadSecureSettingsAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Environment environment, PluginsService pluginService) {
        super(settings, "cluster:admin/nodes/reload_secure_settings", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, NodesReloadSecureSettingsRequest::new, NodeRequest::new, "generic", NodesReloadSecureSettingsResponse.NodeResponse.class);
        this.environment = environment;
        this.pluginsService = pluginService;
    }

    @Override
    protected NodesReloadSecureSettingsResponse newResponse(NodesReloadSecureSettingsRequest request, List<NodesReloadSecureSettingsResponse.NodeResponse> responses, List<FailedNodeException> failures) {
        return new NodesReloadSecureSettingsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, NodesReloadSecureSettingsRequest request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse newNodeResponse() {
        return new NodesReloadSecureSettingsResponse.NodeResponse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse nodeOperation(NodeRequest nodeReloadRequest) {
        try (KeyStoreWrapper keystore = KeyStoreWrapper.load(this.environment.configFile());){
            if (keystore == null) {
                NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), new IllegalStateException("Keystore is missing"));
                return nodeResponse;
            }
            keystore.decrypt(new char[0]);
            Settings settingsWithKeystore = Settings.builder().put(this.environment.settings(), false).setSecureSettings(keystore).build();
            ArrayList exceptions = new ArrayList();
            this.pluginsService.filterPlugins(ReloadablePlugin.class).stream().forEach(p -> {
                try {
                    p.reload(settingsWithKeystore);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("Reload failed for plugin [{}]", (Object)p.getClass().getSimpleName()), (Throwable)e);
                    exceptions.add(e);
                }
            });
            ExceptionsHelper.rethrowAndSuppress(exceptions);
            NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), null);
            return nodeResponse;
        }
        catch (Exception e) {
            return new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), e);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodesReloadSecureSettingsRequest request;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, NodesReloadSecureSettingsRequest request) {
            super(nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesReloadSecureSettingsRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

